/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.util.StringUtil;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

class EnumFilterConverter<E extends Enum<E>>
extends Converter.Contextless<Set<E>> {
    private final Set<String> allowedValues = new LinkedHashSet<String>();
    private final Class<E> typeClass;
    private final String prettyEnumName;

    EnumFilterConverter(Class<E> typeClass, String userFriendlyName) {
        this.typeClass = typeClass;
        this.prettyEnumName = userFriendlyName;
        for (Enum value : EnumSet.allOf(typeClass)) {
            this.allowedValues.add(value.name());
        }
    }

    @Override
    public Set<E> convert(String input) throws OptionsParsingException {
        if (input.isEmpty()) {
            return Collections.emptySet();
        }
        EnumSet<E> includedSet = EnumSet.noneOf(this.typeClass);
        EnumSet<E> excludedSet = EnumSet.noneOf(this.typeClass);
        for (String value : input.split(",", -1)) {
            boolean excludeFlag = value.startsWith("-");
            String s2 = (excludeFlag ? value.substring(1) : value).toUpperCase();
            if (!this.allowedValues.contains(s2)) {
                throw new OptionsParsingException("Invalid " + this.prettyEnumName + " filter '" + value + "' in the input '" + input + "'");
            }
            (excludeFlag ? excludedSet : includedSet).add(Enum.valueOf(this.typeClass, s2));
        }
        if (includedSet.isEmpty()) {
            includedSet = EnumSet.complementOf(excludedSet);
        } else {
            includedSet.removeAll(excludedSet);
        }
        if (includedSet.isEmpty()) {
            throw new OptionsParsingException(Character.toUpperCase(this.prettyEnumName.charAt(0)) + this.prettyEnumName.substring(1) + " filter '" + input + "' definition cannot match any tests");
        }
        return includedSet;
    }

    @Override
    public final String getTypeDescription() {
        return "comma-separated list of values: " + StringUtil.joinEnglishList(this.allowedValues).toLowerCase();
    }
}

