/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.Type;
import java.util.function.BiPredicate;

public interface DependencyFilter
extends BiPredicate<AttributeInfoProvider, Attribute> {
    public static final DependencyFilter ALL_DEPS = (infoProvider, attribute) -> true;
    public static final DependencyFilter ONLY_TARGET_DEPS = (infoProvider, attribute) -> !attribute.isToolDependency();
    public static final DependencyFilter NO_IMPLICIT_DEPS = AttributeInfoProvider::isAttributeValueExplicitlySpecified;
    public static final DependencyFilter NO_NODEP_ATTRIBUTES = (infoProvider, attribute) -> attribute.getType().getLabelClass() != Type.LabelClass.NONDEP_REFERENCE;
    public static final DependencyFilter NO_NODEP_ATTRIBUTES_EXCEPT_VISIBILITY = (infoProvider, attribute) -> NO_NODEP_ATTRIBUTES.test(infoProvider, attribute) || attribute.getName().equals("visibility");

    default public DependencyFilter and(BiPredicate<? super AttributeInfoProvider, ? super Attribute> other) {
        return BiPredicate.super.and(other)::test;
    }

    public static interface AttributeInfoProvider {
        public boolean isAttributeValueExplicitlySpecified(Attribute var1);
    }
}

