/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageArgument;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.server.FailureDetails;
import java.util.List;
import java.util.Set;
import net.starlark.java.eval.EvalException;
import net.starlark.java.syntax.Location;

final class DefaultPackageArguments {
    private DefaultPackageArguments() {
    }

    static ImmutableList<PackageArgument<?>> get() {
        return ImmutableList.of(new DefaultDeprecation(), new DefaultDistribs(), new DefaultApplicableLicenses(), new DefaultPackageMetadata(), new DefaultLicenses(), new DefaultTestOnly(), new DefaultVisibility(), new Features(), new DefaultCompatibleWith(), new DefaultRestrictedTo());
    }

    private static class DefaultRestrictedTo
    extends PackageArgument<List<Label>> {
        private static final String DEFAULT_RESTRICTED_TO_ATTRIBUTE = "default_restricted_to";

        private DefaultRestrictedTo() {
            super(DEFAULT_RESTRICTED_TO_ATTRIBUTE, BuildType.LABEL_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<Label> value) {
            pkgBuilder.setDefaultRestrictedTo(value, DEFAULT_RESTRICTED_TO_ATTRIBUTE, location);
        }
    }

    private static class DefaultCompatibleWith
    extends PackageArgument<List<Label>> {
        private static final String DEFAULT_COMPATIBLE_WITH_ATTRIBUTE = "default_compatible_with";

        private DefaultCompatibleWith() {
            super(DEFAULT_COMPATIBLE_WITH_ATTRIBUTE, BuildType.LABEL_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<Label> value) {
            pkgBuilder.setDefaultCompatibleWith(value, DEFAULT_COMPATIBLE_WITH_ATTRIBUTE, location);
        }
    }

    private static class DefaultDistribs
    extends PackageArgument<Set<License.DistributionType>> {
        private DefaultDistribs() {
            super("distribs", BuildType.DISTRIBUTIONS);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, Set<License.DistributionType> value) {
            pkgBuilder.setDefaultDistribs(value);
        }
    }

    private static class DefaultLicenses
    extends PackageArgument<License> {
        private DefaultLicenses() {
            super("licenses", BuildType.LICENSE);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, License value) {
            pkgBuilder.setDefaultLicense(value);
        }
    }

    private static class DefaultPackageMetadata
    extends PackageArgument<List<Label>> {
        private static final String DEFAULT_PACKAGE_METADATA_ATTRIBUTE = "default_package_metadata";

        private DefaultPackageMetadata() {
            super(DEFAULT_PACKAGE_METADATA_ATTRIBUTE, BuildType.LABEL_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<Label> value) {
            if (!pkgBuilder.getDefaultPackageMetadata().isEmpty()) {
                pkgBuilder.addEvent(Package.error(location, "Can not set both default_package_metadata and default_applicable_licenses. Move all declarations to default_package_metadata.", FailureDetails.PackageLoading.Code.INVALID_PACKAGE_SPECIFICATION));
            }
            pkgBuilder.setDefaultPackageMetadata(value, DEFAULT_PACKAGE_METADATA_ATTRIBUTE, location);
        }
    }

    private static class DefaultApplicableLicenses
    extends PackageArgument<List<Label>> {
        private DefaultApplicableLicenses() {
            super("default_applicable_licenses", BuildType.LABEL_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<Label> value) {
            if (!pkgBuilder.getDefaultPackageMetadata().isEmpty()) {
                pkgBuilder.addEvent(Package.error(location, "Can not set both default_package_metadata and default_applicable_licenses. Move all declarations to default_package_metadata.", FailureDetails.PackageLoading.Code.INVALID_PACKAGE_SPECIFICATION));
            }
            pkgBuilder.setDefaultPackageMetadata(value, "default_package_metadata", location);
        }
    }

    private static class Features
    extends PackageArgument<List<String>> {
        private Features() {
            super("features", Type.STRING_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<String> value) {
            pkgBuilder.addFeatures(value);
        }
    }

    private static class DefaultDeprecation
    extends PackageArgument<String> {
        private DefaultDeprecation() {
            super("default_deprecation", Type.STRING);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, String value) {
            pkgBuilder.setDefaultDeprecation(value);
        }
    }

    private static class DefaultTestOnly
    extends PackageArgument<Boolean> {
        private DefaultTestOnly() {
            super("default_testonly", Type.BOOLEAN);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, Boolean value) {
            pkgBuilder.setDefaultTestonly(value);
        }
    }

    private static class DefaultVisibility
    extends PackageArgument<List<Label>> {
        private DefaultVisibility() {
            super("default_visibility", BuildType.LABEL_LIST);
        }

        @Override
        protected void process(Package.Builder pkgBuilder, Location location, List<Label> value) throws EvalException {
            pkgBuilder.setDefaultVisibility(RuleVisibility.parse(value));
        }
    }
}

