/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.analysis.config.Fragment;
import com.google.devtools.build.lib.analysis.config.FragmentClassSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.starlark.java.annot.StarlarkAnnotations;
import net.starlark.java.annot.StarlarkBuiltin;

public final class ConfigurationFragmentPolicy {
    private final FragmentClassSet requiredConfigurationFragments;
    private final ImmutableSet<String> starlarkRequiredConfigurationFragments;
    private final ImmutableMap<Class<?>, MissingFragmentPolicy> missingFragmentPolicy;

    private ConfigurationFragmentPolicy(FragmentClassSet requiredConfigurationFragments, ImmutableSet<String> starlarkRequiredConfigurationFragments, ImmutableMap<Class<?>, MissingFragmentPolicy> missingFragmentPolicy) {
        this.requiredConfigurationFragments = requiredConfigurationFragments;
        this.starlarkRequiredConfigurationFragments = starlarkRequiredConfigurationFragments;
        this.missingFragmentPolicy = missingFragmentPolicy;
    }

    public FragmentClassSet getRequiredConfigurationFragments() {
        return this.requiredConfigurationFragments;
    }

    public ImmutableCollection<String> getRequiredStarlarkFragments() {
        return this.starlarkRequiredConfigurationFragments;
    }

    public boolean isLegalConfigurationFragment(Class<?> configurationFragment) {
        return this.requiredConfigurationFragments.contains(configurationFragment) || this.hasLegalFragmentName(configurationFragment);
    }

    private boolean hasLegalFragmentName(Class<?> configurationFragment) {
        StarlarkBuiltin fragmentModule = StarlarkAnnotations.getStarlarkBuiltin(configurationFragment);
        return fragmentModule != null && this.starlarkRequiredConfigurationFragments.contains(fragmentModule.name());
    }

    public MissingFragmentPolicy getMissingFragmentPolicy(Class<?> fragmentClass) {
        return this.missingFragmentPolicy.getOrDefault(fragmentClass, MissingFragmentPolicy.FAIL_ANALYSIS);
    }

    public static final class Builder {
        private final Set<Class<? extends Fragment>> requiredConfigurationFragments = new HashSet<Class<? extends Fragment>>();
        private final Set<String> starlarkRequiredConfigurationFragments = new LinkedHashSet<String>();
        private final Map<Class<?>, MissingFragmentPolicy> missingFragmentPolicy = new LinkedHashMap();

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragments(Collection<Class<? extends Fragment>> configurationFragments) {
            this.requiredConfigurationFragments.addAll(configurationFragments);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragmentsByStarlarkBuiltinName(Collection<String> configurationFragmentNames) {
            this.starlarkRequiredConfigurationFragments.addAll(configurationFragmentNames);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder includeConfigurationFragmentsFrom(ConfigurationFragmentPolicy other) {
            this.requiredConfigurationFragments.addAll(other.requiredConfigurationFragments);
            this.starlarkRequiredConfigurationFragments.addAll(other.starlarkRequiredConfigurationFragments);
            this.missingFragmentPolicy.putAll(other.missingFragmentPolicy);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMissingFragmentPolicy(Class<?> fragmentClass, MissingFragmentPolicy missingFragmentPolicy) {
            this.missingFragmentPolicy.put(fragmentClass, missingFragmentPolicy);
            return this;
        }

        public ConfigurationFragmentPolicy build() {
            return new ConfigurationFragmentPolicy(FragmentClassSet.of(this.requiredConfigurationFragments), ImmutableSet.copyOf(this.starlarkRequiredConfigurationFragments), ImmutableMap.copyOf(this.missingFragmentPolicy));
        }
    }

    public static enum MissingFragmentPolicy {
        IGNORE,
        CREATE_FAIL_ACTIONS,
        FAIL_ANALYSIS;

    }
}

