/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.util.HashCodes;
import com.google.devtools.build.lib.util.StringCanonicalizer;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

final class CallStack {
    private static final Interner<Node> nodeInterner = BlazeInterners.newWeakInterner();

    private CallStack() {
    }

    @Nullable
    static Node compactInterior(List<StarlarkThread.CallStackEntry> stack) {
        Node node = null;
        for (int i = stack.size() - 1; i > 0; --i) {
            StarlarkThread.CallStackEntry entry = stack.get(i);
            node = nodeInterner.intern(new Node(entry.name, entry.location, node));
        }
        return node;
    }

    static final class Deserializer {
        private static final Node DUMMY_NODE = new Node("", "", -1, -1, null);
        private final List<Node> nodeTable = new ArrayList<Node>();
        @Nullable
        private List<String> stringTable;

        Deserializer() {
            this.nodeTable.add(null);
        }

        Node deserializeFullCallStack(CodedInputStream codedIn) throws IOException {
            if (this.stringTable == null) {
                int length = codedIn.readInt32();
                this.stringTable = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    this.stringTable.add(StringCanonicalizer.intern(codedIn.readString()));
                }
            }
            return this.readNode(codedIn);
        }

        @Nullable
        private Node readNode(CodedInputStream codedIn) throws IOException {
            int index = codedIn.readInt32();
            if (index < this.nodeTable.size()) {
                Node result = this.nodeTable.get(index);
                Preconditions.checkState(result != DUMMY_NODE, "Loop detected at index %s", index);
                return result;
            }
            Preconditions.checkState(index == this.nodeTable.size(), "Unexpected next value index - read %s, expected %s", index, this.nodeTable.size());
            this.nodeTable.add(DUMMY_NODE);
            int name = codedIn.readInt32();
            int file = codedIn.readInt32();
            int line = codedIn.readInt32();
            int col = codedIn.readInt32();
            Node child = this.readNode(codedIn);
            Node result = new Node(this.stringTable.get(name), this.stringTable.get(file), line, col, child);
            this.nodeTable.set(index, result);
            return result;
        }
    }

    static final class Serializer {
        private static final int NULL_NODE_ID = 0;
        private final IdentityHashMap<Node, Integer> nodeTable = new IdentityHashMap();
        private final List<String> stringTable = new ArrayList<String>();
        private boolean stringTableSerialized = false;
        private final Map<String, Integer> stringTableIndex = new HashMap<String, Integer>();

        Serializer() {
            this.nodeTable.put(null, 0);
            this.indexString("<toplevel>");
        }

        private void indexString(String s2) {
            Preconditions.checkState(!this.stringTableSerialized);
            int i = this.stringTableIndex.size();
            if (this.stringTableIndex.putIfAbsent(s2, i) == null) {
                this.stringTable.add(s2);
            }
        }

        private int indexOf(String s2) {
            return Preconditions.checkNotNull(this.stringTableIndex.get(s2), s2);
        }

        void serializeCallStack(Rule rule, CodedOutputStream codedOut) throws IOException {
            if (!this.stringTableSerialized) {
                codedOut.writeInt32NoTag(this.stringTable.size());
                for (String string : this.stringTable) {
                    codedOut.writeStringNoTag(string);
                }
                this.stringTableSerialized = true;
            }
            this.emitNode(new Node("<toplevel>", rule.getLocation(), rule.getInteriorCallStack()), codedOut);
        }

        private void emitNode(Node node, CodedOutputStream codedOut) throws IOException {
            Integer index = this.nodeTable.get(node);
            if (index != null) {
                codedOut.writeInt32NoTag(index);
                return;
            }
            if (node == null) {
                return;
            }
            int newIndex = this.nodeTable.size();
            codedOut.writeInt32NoTag(newIndex);
            this.nodeTable.put(node, newIndex);
            codedOut.writeInt32NoTag(this.indexOf(node.name));
            codedOut.writeInt32NoTag(this.indexOf(node.file));
            codedOut.writeInt32NoTag(node.line);
            codedOut.writeInt32NoTag(node.col);
            this.emitNode(node.next, codedOut);
        }

        void prepareCallStack(Rule rule) {
            this.indexString(rule.getLocation().file());
            Node n = rule.getInteriorCallStack();
            while (n != null) {
                this.indexString(n.name);
                this.indexString(n.file);
                n = n.next;
            }
        }
    }

    static final class Node {
        private final String name;
        private final String file;
        private final int line;
        private final int col;
        @Nullable
        private final Node next;

        private Node(String name, Location location, @Nullable Node next) {
            this(name, location.file(), location.line(), location.column(), next);
        }

        private Node(String name, String file, int line, int col, @Nullable Node next) {
            this.name = name;
            this.file = file;
            this.line = line;
            this.col = col;
            this.next = next;
        }

        Location toLocation() {
            return Location.fromFileLineColumn(this.file, this.line, this.col);
        }

        StarlarkThread.CallStackEntry toCallStackEntry() {
            return StarlarkThread.callStackEntry(this.name, this.toLocation());
        }

        String functionName() {
            return this.name;
        }

        @Nullable
        Node next() {
            return this.next;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.line == node.line && this.col == node.col && this.name.equals(node.name) && this.file.equals(node.file) && Objects.equals(this.next, node.next);
        }

        public int hashCode() {
            int result = HashCodes.hashObjects(this.name, this.file, this.next);
            result = result * 31 + Integer.hashCode(this.line);
            result = result * 31 + Integer.hashCode(this.col);
            return result;
        }
    }
}

