/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.packages.PackageSpecification;
import java.util.List;

public abstract class BzlVisibility {
    public static final BzlVisibility PUBLIC = new BzlVisibility(){

        @Override
        public boolean allowsPackage(PackageIdentifier pkg) {
            return true;
        }
    };
    public static final BzlVisibility PRIVATE = new BzlVisibility(){

        @Override
        public boolean allowsPackage(PackageIdentifier pkg) {
            return false;
        }
    };

    private BzlVisibility() {
    }

    public abstract boolean allowsPackage(PackageIdentifier var1);

    public static BzlVisibility of(List<PackageSpecification> specs) {
        if (specs.isEmpty() || specs.size() == 1 && specs.get(0) instanceof PackageSpecification.NoPackages) {
            return PRIVATE;
        }
        for (PackageSpecification spec : specs) {
            if (!(spec instanceof PackageSpecification.AllPackages)) continue;
            return PUBLIC;
        }
        return new ListBzlVisibility(specs);
    }

    private static class ListBzlVisibility
    extends BzlVisibility {
        private final ImmutableList<PackageSpecification> specs;

        public ListBzlVisibility(List<PackageSpecification> specs) {
            this.specs = ImmutableList.copyOf(specs);
        }

        @Override
        public boolean allowsPackage(PackageIdentifier pkg) {
            for (PackageSpecification spec : this.specs) {
                if (!spec.containsPackage(pkg)) continue;
                return true;
            }
            return false;
        }
    }
}

