/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.BzlVisibility;
import com.google.devtools.build.lib.packages.SymbolGenerator;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;

public final class BzlInitThreadContext
extends BazelStarlarkContext {
    private final Label bzlFile;
    @Nullable
    private BzlVisibility bzlVisibility;

    public BzlInitThreadContext(Label bzlFile, @Nullable RepositoryName toolsRepository, @Nullable ImmutableMap<String, Class<?>> fragmentNameToClass, SymbolGenerator<?> symbolGenerator, @Nullable Label networkAllowlistForTests) {
        super(BazelStarlarkContext.Phase.LOADING, toolsRepository, fragmentNameToClass, symbolGenerator, null, networkAllowlistForTests);
        this.bzlFile = bzlFile;
    }

    public static BzlInitThreadContext from(StarlarkThread thread) {
        BazelStarlarkContext ctx = thread.getThreadLocal(BazelStarlarkContext.class);
        Preconditions.checkState(ctx instanceof BzlInitThreadContext, "Expected to be in a .bzl initialization (top-level evaluation) Starlark thread");
        return (BzlInitThreadContext)ctx;
    }

    public static BzlInitThreadContext fromOrFailFunction(StarlarkThread thread, String function) throws EvalException {
        BazelStarlarkContext ctx = thread.getThreadLocal(BazelStarlarkContext.class);
        if (!(ctx instanceof BzlInitThreadContext)) {
            throw Starlark.errorf("'%s' can only be called during .bzl initialization (top-level evaluation)", function);
        }
        return (BzlInitThreadContext)ctx;
    }

    public Label getBzlFile() {
        return this.bzlFile;
    }

    @Nullable
    public BzlVisibility getBzlVisibility() {
        return this.bzlVisibility;
    }

    public void setBzlVisibility(BzlVisibility bzlVisibility) {
        this.bzlVisibility = bzlVisibility;
    }
}

