/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.packages.Info;
import com.google.devtools.build.lib.packages.Provider;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.util.Fingerprint;
import javax.annotation.Nullable;
import net.starlark.java.eval.Printer;
import net.starlark.java.syntax.Location;

public abstract class BuiltinProvider<T extends Info>
implements Provider {
    private final Key key;
    private final String name;
    private final Class<T> valueClass;

    protected BuiltinProvider(String name, Class<T> valueClass) {
        this.key = new Key(name, this.getClass());
        this.name = name;
        this.valueClass = valueClass;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public final boolean equals(@Nullable Object other) {
        return other != null && this.getClass().equals(other.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean isExported() {
        return true;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Location getLocation() {
        return Location.BUILTIN;
    }

    @Override
    public String getPrintableName() {
        return this.name;
    }

    @Override
    public void repr(Printer printer) {
        printer.append("<function " + this.name + ">");
    }

    public StarlarkProviderIdentifier id() {
        return StarlarkProviderIdentifier.forKey(this.key);
    }

    public static final class Key
    extends Provider.Key {
        private final String name;
        private final Class<? extends Provider> providerClass;

        public Key(String name, Class<? extends Provider> providerClass) {
            this.name = name;
            this.providerClass = providerClass;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Provider> getProviderClass() {
            return this.providerClass;
        }

        @Override
        void fingerprint(Fingerprint fp) {
            fp.addBoolean(true);
            fp.addString(this.name);
        }

        public int hashCode() {
            return this.providerClass.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.providerClass.equals(((Key)obj).providerClass);
        }

        public String toString() {
            return this.name;
        }
    }

    @Deprecated
    public static interface WithLegacyStarlarkName {
        public String getStarlarkName();
    }
}

