/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.LabelConverter;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.SelectorValue;
import com.google.devtools.build.lib.packages.TriState;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkValue;

public final class BuildType {
    @SerializationConstant
    public static final Type<Label> LABEL = new LabelType(Type.LabelClass.DEPENDENCY);
    @SerializationConstant
    public static final Type.DictType<String, Label> LABEL_DICT_UNARY = Type.DictType.create(Type.STRING, LABEL);
    @SerializationConstant
    public static final Type.DictType<Label, String> LABEL_KEYED_STRING_DICT = LabelKeyedDictType.create(Type.STRING);
    @SerializationConstant
    public static final Type.ListType<Label> LABEL_LIST = Type.ListType.create(LABEL);
    @SerializationConstant
    public static final Type<Label> NODEP_LABEL = new LabelType(Type.LabelClass.NONDEP_REFERENCE);
    @SerializationConstant
    public static final Type.ListType<Label> NODEP_LABEL_LIST = Type.ListType.create(NODEP_LABEL);
    @SerializationConstant
    public static final Type<Label> GENQUERY_SCOPE_TYPE = new LabelType(Type.LabelClass.GENQUERY_SCOPE_REFERENCE);
    @SerializationConstant
    public static final Type.ListType<Label> GENQUERY_SCOPE_TYPE_LIST = Type.ListType.create(GENQUERY_SCOPE_TYPE);
    @SerializationConstant
    public static final Type<License> LICENSE = new LicenseType();
    @SerializationConstant
    static final Type<License.DistributionType> DISTRIBUTION = new Type<License.DistributionType>(){

        @Override
        public License.DistributionType cast(Object value) {
            return (License.DistributionType)((Object)value);
        }

        @Override
        public License.DistributionType convert(Object x, Object what, LabelConverter labelConverter) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public License.DistributionType getDefaultValue() {
            return null;
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, License.DistributionType value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "distribution";
        }
    };
    @SerializationConstant
    public static final Type<Set<License.DistributionType>> DISTRIBUTIONS = new Distributions();
    @SerializationConstant
    public static final Type<Label> OUTPUT = new OutputType();
    @SerializationConstant
    public static final Type.ListType<Label> OUTPUT_LIST = Type.ListType.create(OUTPUT);
    @SerializationConstant
    public static final Type<TriState> TRISTATE = new TriStateType();

    private BuildType() {
    }

    public static boolean isLabelType(Type<?> type) {
        return type.getLabelClass() != Type.LabelClass.NONE;
    }

    public static <T> Object selectableConvert(Type<T> type, Object x, Object what, LabelConverter context) throws Type.ConversionException {
        if (x instanceof com.google.devtools.build.lib.packages.SelectorList) {
            return new SelectorList<T>(((com.google.devtools.build.lib.packages.SelectorList)x).getElements(), what, context, type);
        }
        return type.convert(x, what, context);
    }

    private static final class TriStateType
    extends Type<TriState> {
        private TriStateType() {
        }

        @Override
        public TriState cast(Object value) {
            return (TriState)((Object)value);
        }

        @Override
        public TriState getDefaultValue() {
            return TriState.AUTO;
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, TriState value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "tristate";
        }

        @Override
        public TriState convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            if (x instanceof TriState) {
                return (TriState)((Object)x);
            }
            if (x instanceof Boolean) {
                return (Boolean)x != false ? TriState.YES : TriState.NO;
            }
            int xAsInteger = ((StarlarkInt)INTEGER.convert(x, what, labelConverter)).toIntUnchecked();
            if (xAsInteger == -1) {
                return TriState.AUTO;
            }
            if (xAsInteger == 1) {
                return TriState.YES;
            }
            if (xAsInteger == 0) {
                return TriState.NO;
            }
            throw new Type.ConversionException(this, x, "TriState values is not one of [-1, 0, 1]");
        }
    }

    public static final class Selector<T> {
        @VisibleForTesting
        public static final String DEFAULT_CONDITION_KEY = "//conditions:default";
        static final Label DEFAULT_CONDITION_LABEL = Label.parseCanonicalUnchecked("//conditions:default");
        private final Type<T> originalType;
        private final Label[] labels;
        private final T[] values;
        private final Set<Label> conditionsWithDefaultValues;
        private final String noMatchError;
        private final int defaultConditionPos;

        Selector(ImmutableMap<?, ?> x, Object what, @Nullable LabelConverter context, Type<T> originalType) throws Type.ConversionException {
            this(x, what, context, originalType, "");
        }

        Selector(ImmutableMap<?, ?> x, Object what, @Nullable LabelConverter context, Type<T> originalType, String noMatchError) throws Type.ConversionException {
            this.originalType = originalType;
            Label[] labels = new Label[x.size()];
            Object[] values = new Object[x.size()];
            ImmutableSet.Builder defaultValuesBuilder = ImmutableSet.builder();
            int pos = 0;
            int defaultConditionPos = -1;
            for (Map.Entry entry : x.entrySet()) {
                T value;
                Label key;
                labels[pos] = key = LABEL.convert(entry.getKey(), what, context);
                if (entry.getValue() == Starlark.NONE) {
                    value = originalType.getDefaultValue();
                    defaultValuesBuilder.add(key);
                } else {
                    SelectBranchMessage selectBranch = what == null ? null : new SelectBranchMessage(what, key);
                    value = originalType.convert(entry.getValue(), selectBranch, context);
                }
                if (key.equals(DEFAULT_CONDITION_LABEL)) {
                    defaultConditionPos = pos;
                }
                values[pos] = value;
                ++pos;
            }
            this.labels = labels;
            this.values = values;
            this.noMatchError = noMatchError;
            this.conditionsWithDefaultValues = defaultValuesBuilder.build();
            this.defaultConditionPos = defaultConditionPos;
        }

        Selector(Label[] labels, T[] values, Type<T> originalType, String noMatchError, ImmutableSet<Label> conditionsWithDefaultValues, int defaultConditionPos) {
            this.labels = labels;
            this.values = values;
            this.originalType = originalType;
            this.noMatchError = noMatchError;
            this.conditionsWithDefaultValues = conditionsWithDefaultValues;
            this.defaultConditionPos = defaultConditionPos;
        }

        public boolean hasDefault() {
            return this.defaultConditionPos >= 0;
        }

        @Nullable
        public T getDefault() {
            return this.defaultConditionPos < 0 ? null : (T)this.values[this.defaultConditionPos];
        }

        public ArrayList<T> valuesCopy() {
            ArrayList result = Lists.newArrayListWithCapacity(this.getNumEntries());
            this.forEach((label, value) -> result.add(value));
            return result;
        }

        public LinkedHashMap<Label, T> mapCopy() {
            LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize(this.getNumEntries());
            this.forEach(result::put);
            return result;
        }

        public void forEach(SelectorEntryConsumer<T> consumer) {
            for (int i = 0; i < this.labels.length; ++i) {
                consumer.accept(this.labels[i], this.values[i]);
            }
        }

        public <E1 extends Exception, E2 extends Exception> void forEachExceptionally(ExceptionalSelectorEntryConsumer<T, E1, E2> consumer) throws E1, E2 {
            for (int i = 0; i < this.labels.length; ++i) {
                consumer.accept(this.labels[i], this.values[i]);
            }
        }

        public int getNumEntries() {
            return this.labels.length;
        }

        public Type<T> getOriginalType() {
            return this.originalType;
        }

        public boolean isUnconditional() {
            return this.labels.length == 1 && this.defaultConditionPos >= 0;
        }

        public boolean isValueSet(Label condition) {
            return !this.conditionsWithDefaultValues.contains(condition);
        }

        public String getNoMatchError() {
            return this.noMatchError;
        }

        public static boolean isDefaultConditionLabel(Label label) {
            return DEFAULT_CONDITION_LABEL.equals(label);
        }

        static interface ExceptionalSelectorEntryConsumer<T, E1 extends Exception, E2 extends Exception> {
            public void accept(Label var1, @Nullable T var2) throws E1, E2;
        }

        public static interface SelectorEntryConsumer<T> {
            public void accept(Label var1, @Nullable T var2);
        }
    }

    private static final class SelectBranchMessage {
        private final Object what;
        private final Label key;

        SelectBranchMessage(Object what, Label key) {
            this.what = what;
            this.key = key;
        }

        public String toString() {
            return String.format("each branch in select expression of %s (including '%s')", this.what, this.key);
        }
    }

    public static final class SelectorList<T>
    implements StarlarkValue {
        private final Type<T> originalType;
        private final List<Selector<T>> elements;

        @VisibleForTesting
        SelectorList(List<Object> x, Object what, @Nullable LabelConverter context, Type<T> originalType) throws Type.ConversionException {
            if (x.size() > 1 && originalType.concat(ImmutableList.of()) == null) {
                throw new Type.ConversionException(String.format("type '%s' doesn't support select concatenation", originalType));
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object elem : x) {
                if (elem instanceof SelectorValue) {
                    builder.add(new Selector<T>(((SelectorValue)elem).getDictionary(), what, context, originalType, ((SelectorValue)elem).getNoMatchError()));
                    continue;
                }
                T directValue = originalType.convert(elem, what, context);
                builder.add(new Selector<T>(ImmutableMap.of("//conditions:default", directValue), what, context, originalType));
            }
            this.originalType = originalType;
            this.elements = builder.build();
        }

        SelectorList(List<Selector<T>> elements, Type<T> originalType) {
            this.elements = ImmutableList.copyOf(elements);
            this.originalType = originalType;
        }

        public List<Selector<T>> getSelectors() {
            return this.elements;
        }

        public Type<T> getOriginalType() {
            return this.originalType;
        }

        public Set<Label> getKeyLabels() {
            ImmutableSet.Builder keys = ImmutableSet.builder();
            for (Selector<Object> selector : this.elements) {
                selector.forEach((label, value) -> {
                    if (!Selector.isDefaultConditionLabel(label)) {
                        keys.add(label);
                    }
                });
            }
            return keys.build();
        }

        public String toString() {
            return Starlark.repr(this);
        }

        @Override
        public void repr(Printer printer) {
            ArrayList<SelectorValue> selectorValueList = new ArrayList<SelectorValue>();
            for (Selector<T> element : this.elements) {
                selectorValueList.add(new SelectorValue(element.mapCopy(), element.getNoMatchError()));
            }
            try {
                printer.repr(com.google.devtools.build.lib.packages.SelectorList.of(selectorValueList));
            }
            catch (EvalException e) {
                throw new IllegalStateException("this list should have been validated on creation", e);
            }
        }
    }

    private static final class OutputType
    extends Type<Label> {
        private OutputType() {
        }

        @Override
        public Label cast(Object value) {
            return (Label)value;
        }

        @Override
        @Nullable
        public Label getDefaultValue() {
            return null;
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, Label value, @Nullable Attribute context) {
            visitor.visit(value, context);
        }

        @Override
        public Type.LabelClass getLabelClass() {
            return Type.LabelClass.OUTPUT;
        }

        @Override
        public String toString() {
            return "output";
        }

        @Override
        public Label convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            Label result = LABEL.convert(x, what, labelConverter);
            if (!result.getPackageIdentifier().equals(labelConverter.getBasePackage())) {
                throw new Type.ConversionException("label '" + x + "' is not in the current package");
            }
            return result;
        }
    }

    private static final class Distributions
    extends Type<Set<License.DistributionType>> {
        private Distributions() {
        }

        @Override
        public Set<License.DistributionType> cast(Object value) {
            return (Set)value;
        }

        @Override
        public Set<License.DistributionType> convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            try {
                List distribStrings = (List)STRING_LIST.convert(x, what);
                return License.parseDistributions(distribStrings);
            }
            catch (License.LicenseParsingException e) {
                throw new Type.ConversionException(e.getMessage());
            }
        }

        @Override
        public Set<License.DistributionType> getDefaultValue() {
            return Collections.emptySet();
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, Set<License.DistributionType> value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "distributions";
        }

        @Override
        public Type<License.DistributionType> getListElementType() {
            return DISTRIBUTION;
        }
    }

    public static final class LicenseType
    extends Type<License> {
        @Override
        public License cast(Object value) {
            return (License)value;
        }

        @Override
        public License convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            try {
                List licenseStrings = (List)STRING_LIST.convert(x, what);
                return License.parseLicense(licenseStrings);
            }
            catch (License.LicenseParsingException e) {
                throw new Type.ConversionException(e.getMessage());
            }
        }

        @Override
        public License getDefaultValue() {
            return License.NO_LICENSE;
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, License value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "license";
        }
    }

    private static class LabelKeyedDictType<ValueT>
    extends Type.DictType<Label, ValueT> {
        private LabelKeyedDictType(Type<ValueT> valueType) {
            super(LABEL, valueType, Type.LabelClass.DEPENDENCY);
        }

        static <ValueT> LabelKeyedDictType<ValueT> create(Type<ValueT> valueType) {
            Preconditions.checkArgument(valueType.getLabelClass() == Type.LabelClass.NONE || valueType.getLabelClass() == Type.LabelClass.DEPENDENCY, "Values associated with label keys must not be labels themselves.");
            return new LabelKeyedDictType<ValueT>(valueType);
        }

        @Override
        public Map<Label, ValueT> convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            Object result = super.convert(x, what, labelConverter);
            Map input = (Map)x;
            if (input.size() == result.size()) {
                return result;
            }
            LinkedHashMap<Label, List> convertedFrom = new LinkedHashMap<Label, List>();
            for (Object original : input.keySet()) {
                Label label = LABEL.convert(original, what, labelConverter);
                convertedFrom.computeIfAbsent(label, k -> new ArrayList()).add(original);
            }
            Printer errorMessage = new Printer();
            errorMessage.append("duplicate labels");
            if (what != null) {
                errorMessage.append(" in ").append(what.toString());
            }
            errorMessage.append(':');
            boolean isFirstEntry = true;
            for (Map.Entry entry : convertedFrom.entrySet()) {
                if (((List)entry.getValue()).size() == 1) continue;
                if (isFirstEntry) {
                    isFirstEntry = false;
                } else {
                    errorMessage.append(',');
                }
                errorMessage.append(' ');
                errorMessage.append(((Label)entry.getKey()).getCanonicalForm());
                errorMessage.append(" (as ");
                errorMessage.repr(entry.getValue());
                errorMessage.append(')');
            }
            throw new Type.ConversionException(errorMessage.toString());
        }
    }

    private static class LabelType
    extends Type<Label> {
        private final Type.LabelClass labelClass;

        LabelType(Type.LabelClass labelClass) {
            this.labelClass = labelClass;
        }

        @Override
        public Label cast(Object value) {
            return (Label)value;
        }

        @Override
        public Label getDefaultValue() {
            return null;
        }

        @Override
        public void visitLabels(Type.LabelVisitor visitor, Label value, @Nullable Attribute context) {
            visitor.visit(value, context);
        }

        @Override
        public String toString() {
            return "label";
        }

        @Override
        public Type.LabelClass getLabelClass() {
            return this.labelClass;
        }

        @Override
        public Label convert(Object x, Object what, LabelConverter labelConverter) throws Type.ConversionException {
            if (x instanceof Label) {
                return (Label)x;
            }
            if (!(x instanceof String)) {
                throw new Type.ConversionException(Type.STRING, x, what);
            }
            try {
                if (labelConverter == null) {
                    return Label.parseCanonical((String)x);
                }
                return labelConverter.convert((String)x);
            }
            catch (LabelSyntaxException e) {
                throw new Type.ConversionException("invalid label '" + x + "' in " + what + ": " + e.getMessage());
            }
        }
    }
}

