/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkConfigApi;
import net.starlark.java.eval.Printer;

public class BuildSetting
implements StarlarkConfigApi.BuildSettingApi {
    private final boolean isFlag;
    private final Type<?> type;
    private final boolean allowMultiple;
    private final boolean repeatable;

    private BuildSetting(boolean isFlag, Type<?> type, boolean allowMultiple, boolean repeatable) {
        this.isFlag = isFlag;
        this.type = type;
        this.allowMultiple = allowMultiple;
        this.repeatable = repeatable;
    }

    public static BuildSetting create(boolean isFlag, Type<?> type, boolean allowMultiple, boolean repeatable) {
        return new BuildSetting(isFlag, type, allowMultiple, repeatable);
    }

    public static BuildSetting create(boolean isFlag, Type<?> type) {
        Preconditions.checkState(type.getLabelClass() != Type.LabelClass.DEPENDENCY, "Build settings should not create a dependency with their default attribute");
        return new BuildSetting(isFlag, type, false, false);
    }

    public Type<?> getType() {
        return this.type;
    }

    @VisibleForTesting
    public boolean isFlag() {
        return this.isFlag;
    }

    public boolean allowsMultiple() {
        return this.allowMultiple;
    }

    public boolean isRepeatableFlag() {
        return this.repeatable;
    }

    @Override
    public void repr(Printer printer) {
        printer.append("<build_setting." + this.type + ">");
    }
}

