/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.docgen.annot.GlobalMethods;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.server.FailureDetails;
import java.util.List;
import java.util.Set;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

@GlobalMethods(environment={GlobalMethods.Environment.BUILD})
class BuildGlobals {
    static final BuildGlobals INSTANCE = new BuildGlobals();

    private BuildGlobals() {
    }

    @StarlarkMethod(name="environment_group", doc="Defines a set of related environments that can be tagged onto rules to preventincompatible rules from depending on each other.", parameters={@Param(name="name", positional=false, named=true, doc="The name of the rule."), @Param(name="environments", allowedTypes={@ParamType(type=Sequence.class, generic1=Label.class)}, positional=false, named=true, doc="A list of Labels for the environments to be grouped, from the same package."), @Param(name="defaults", allowedTypes={@ParamType(type=Sequence.class, generic1=Label.class)}, positional=false, named=true, doc="A list of Labels.")}, documented=false, useStarlarkThread=true)
    public NoneType environmentGroup(String name, Sequence<?> environmentsList, Sequence<?> defaultsList, StarlarkThread thread) throws EvalException {
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        Object environments = BuildType.LABEL_LIST.convert(environmentsList, "'environment_group argument'", context.pkgBuilder.getLabelConverter());
        Object defaults = BuildType.LABEL_LIST.convert(defaultsList, "'environment_group argument'", context.pkgBuilder.getLabelConverter());
        if (environments.isEmpty()) {
            throw Starlark.errorf("environment group %s must contain at least one environment", name);
        }
        try {
            Location loc = thread.getCallerLocation();
            context.pkgBuilder.addEnvironmentGroup(name, (List<Label>)environments, (List<Label>)defaults, context.eventHandler, loc);
            return Starlark.NONE;
        }
        catch (LabelSyntaxException e) {
            throw Starlark.errorf("environment group has invalid name: %s: %s", name, e.getMessage());
        }
        catch (Package.NameConflictException e) {
            throw Starlark.errorf("%s", e.getMessage());
        }
    }

    @StarlarkMethod(name="licenses", doc="Declare the license(s) for the code in the current package.", parameters={@Param(name="license_strings", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, doc="A list of strings, the names of the licenses used.")}, documented=false, useStarlarkThread=true)
    public NoneType licenses(Sequence<?> licensesList, StarlarkThread thread) throws EvalException {
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        try {
            License license = BuildType.LICENSE.convert(licensesList, "'licenses' operand");
            context.pkgBuilder.setDefaultLicense(license);
        }
        catch (Type.ConversionException e) {
            context.eventHandler.handle(Package.error(thread.getCallerLocation(), e.getMessage(), FailureDetails.PackageLoading.Code.LICENSE_PARSE_FAILURE));
            context.pkgBuilder.setContainsErrors();
        }
        return Starlark.NONE;
    }

    @StarlarkMethod(name="distribs", doc="Declare the distribution(s) for the code in the current package.", parameters={@Param(name="distribution_strings", doc="The distributions.")}, documented=false, useStarlarkThread=true)
    public NoneType distribs(Object object, StarlarkThread thread) throws EvalException {
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        try {
            Set<License.DistributionType> distribs = BuildType.DISTRIBUTIONS.convert(object, "'distribs' operand");
            context.pkgBuilder.setDefaultDistribs(distribs);
        }
        catch (Type.ConversionException e) {
            context.eventHandler.handle(Package.error(thread.getCallerLocation(), e.getMessage(), FailureDetails.PackageLoading.Code.DISTRIBUTIONS_PARSE_FAILURE));
            context.pkgBuilder.setContainsErrors();
        }
        return Starlark.NONE;
    }
}

