/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.vfs.PathFragment;

public enum BuildFileName {
    WORKSPACE("WORKSPACE"){

        @Override
        public PathFragment getBuildFileFragment(PackageIdentifier packageIdentifier) {
            return this.getFilenameFragment();
        }
    }
    ,
    WORKSPACE_DOT_BAZEL("WORKSPACE.bazel"){

        @Override
        public PathFragment getBuildFileFragment(PackageIdentifier packageIdentifier) {
            return this.getFilenameFragment();
        }
    }
    ,
    BUILD("BUILD"){

        @Override
        public PathFragment getBuildFileFragment(PackageIdentifier packageIdentifier) {
            return packageIdentifier.getPackageFragment().getRelative(this.getFilenameFragment());
        }
    }
    ,
    BUILD_DOT_BAZEL("BUILD.bazel"){

        @Override
        public PathFragment getBuildFileFragment(PackageIdentifier packageIdentifier) {
            return packageIdentifier.getPackageFragment().getRelative(this.getFilenameFragment());
        }
    };

    private final PathFragment filenameFragment;

    private BuildFileName(String filename) {
        this.filenameFragment = PathFragment.create(filename);
    }

    public PathFragment getFilenameFragment() {
        return this.filenameFragment;
    }

    public abstract PathFragment getBuildFileFragment(PackageIdentifier var1);
}

