/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.packages.BuiltinsInternalModule;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.RuleClassProvider;
import com.google.devtools.build.lib.packages.StarlarkLibrary;
import com.google.devtools.build.lib.packages.StarlarkNativeModule;
import com.google.devtools.build.lib.packages.StructProvider;
import com.google.devtools.build.lib.packages.WorkspaceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.starlark.java.eval.GuardedValue;
import net.starlark.java.eval.Starlark;

public final class BazelStarlarkEnvironment {
    private final RuleClassProvider ruleClassProvider;
    private final ImmutableMap<String, ?> ruleFunctions;
    private final ImmutableMap<String, Object> uninjectedBuildBzlNativeBindings;
    private final ImmutableMap<String, Object> workspaceBzlNativeBindings;
    private final ImmutableMap<String, Object> uninjectedBuildBzlEnv;
    private final ImmutableMap<String, Object> uninjectedBuildEnv;
    private final ImmutableMap<String, Object> uninjectedWorkspaceBzlEnv;
    private final ImmutableMap<String, Object> builtinsBzlEnv;
    private final ImmutableMap<String, Object> bzlmodBzlEnv;

    BazelStarlarkEnvironment(RuleClassProvider ruleClassProvider, Object packageFunction) {
        this.ruleClassProvider = ruleClassProvider;
        this.ruleFunctions = ruleClassProvider.getRuleFunctionMap();
        this.uninjectedBuildBzlNativeBindings = BazelStarlarkEnvironment.createUninjectedBuildBzlNativeBindings(this.ruleFunctions, packageFunction, ruleClassProvider.getEnvironmentExtensions());
        this.workspaceBzlNativeBindings = BazelStarlarkEnvironment.createWorkspaceBzlNativeBindings(ruleClassProvider);
        this.uninjectedBuildBzlEnv = BazelStarlarkEnvironment.createUninjectedBuildBzlEnv(ruleClassProvider, this.uninjectedBuildBzlNativeBindings);
        this.uninjectedWorkspaceBzlEnv = BazelStarlarkEnvironment.createWorkspaceBzlEnv(ruleClassProvider, this.workspaceBzlNativeBindings);
        this.bzlmodBzlEnv = BazelStarlarkEnvironment.createWorkspaceBzlEnv(ruleClassProvider, this.workspaceBzlNativeBindings);
        this.builtinsBzlEnv = BazelStarlarkEnvironment.createBuiltinsBzlEnv(ruleClassProvider, this.uninjectedBuildBzlNativeBindings, this.uninjectedBuildBzlEnv);
        this.uninjectedBuildEnv = BazelStarlarkEnvironment.createUninjectedBuildEnv(this.ruleFunctions, packageFunction, ruleClassProvider.getEnvironmentExtensions());
    }

    public ImmutableMap<String, Object> getUninjectedBuildBzlNativeBindings() {
        return this.uninjectedBuildBzlNativeBindings;
    }

    public ImmutableMap<String, Object> getWorkspaceBzlNativeBindings() {
        return this.workspaceBzlNativeBindings;
    }

    public ImmutableMap<String, Object> getUninjectedBuildBzlEnv() {
        return this.uninjectedBuildBzlEnv;
    }

    public ImmutableMap<String, Object> getUninjectedBuildEnv() {
        return this.uninjectedBuildEnv;
    }

    public ImmutableMap<String, Object> getUninjectedWorkspaceBzlEnv() {
        return this.uninjectedWorkspaceBzlEnv;
    }

    public ImmutableMap<String, Object> getBuiltinsBzlEnv() {
        return this.builtinsBzlEnv;
    }

    public ImmutableMap<String, Object> getBzlmodBzlEnv() {
        return this.bzlmodBzlEnv;
    }

    private static ImmutableMap<String, Object> createUninjectedBuildBzlNativeBindings(Map<String, ?> ruleFunctions, Object packageFunction, List<PackageFactory.EnvironmentExtension> environmentExtensions) {
        ImmutableMap.Builder<String, Object> env = new ImmutableMap.Builder<String, Object>();
        env.putAll(StarlarkNativeModule.BINDINGS_FOR_BUILD_FILES);
        env.putAll(ruleFunctions);
        env.put("package", packageFunction);
        for (PackageFactory.EnvironmentExtension ext : environmentExtensions) {
            ext.update(env);
        }
        return env.buildOrThrow();
    }

    private static ImmutableMap<String, Object> createWorkspaceBzlNativeBindings(RuleClassProvider ruleClassProvider) {
        return WorkspaceFactory.createNativeModuleBindings(ruleClassProvider);
    }

    private static Object createNativeModule(Map<String, Object> bindings) {
        return StructProvider.STRUCT.create(bindings, "no native function or rule '%s'");
    }

    private static ImmutableMap<String, Object> createUninjectedBuildBzlEnv(RuleClassProvider ruleClassProvider, Map<String, Object> uninjectedBuildBzlNativeBindings) {
        HashMap<String, Object> env = new HashMap<String, Object>(ruleClassProvider.getEnvironment());
        env.put("native", BazelStarlarkEnvironment.createNativeModule(uninjectedBuildBzlNativeBindings));
        return ImmutableMap.copyOf(env);
    }

    private static ImmutableMap<String, Object> createUninjectedBuildEnv(Map<String, ?> ruleFunctions, Object packageFunction, List<PackageFactory.EnvironmentExtension> environmentExtensions) {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        env.putAll(StarlarkLibrary.BUILD);
        env.putAll(StarlarkNativeModule.BINDINGS_FOR_BUILD_FILES);
        env.put("package", packageFunction);
        env.putAll(ruleFunctions);
        for (PackageFactory.EnvironmentExtension ext : environmentExtensions) {
            ext.update(env);
        }
        return env.buildOrThrow();
    }

    private static ImmutableMap<String, Object> createWorkspaceBzlEnv(RuleClassProvider ruleClassProvider, Map<String, Object> workspaceBzlNativeBindings) {
        HashMap<String, Object> env = new HashMap<String, Object>(ruleClassProvider.getEnvironment());
        env.put("native", BazelStarlarkEnvironment.createNativeModule(workspaceBzlNativeBindings));
        return ImmutableMap.copyOf(env);
    }

    private static ImmutableMap<String, Object> createBuiltinsBzlEnv(RuleClassProvider ruleClassProvider, ImmutableMap<String, Object> uninjectedBuildBzlNativeBindings, ImmutableMap<String, Object> uninjectedBuildBzlEnv) {
        HashMap<String, Object> env = new HashMap<String, Object>(ruleClassProvider.getEnvironment());
        env.keySet().removeAll(ruleClassProvider.getNativeRuleSpecificBindings().keySet());
        HashMap<String, Object> unwrappedBuildBzlSymbols = new HashMap<String, Object>();
        for (Map.Entry entry : uninjectedBuildBzlEnv.entrySet()) {
            Object symbol = entry.getValue();
            if (symbol instanceof GuardedValue) {
                symbol = ((GuardedValue)symbol).getObject();
            }
            unwrappedBuildBzlSymbols.put((String)entry.getKey(), symbol);
        }
        BuiltinsInternalModule builtinsModule = new BuiltinsInternalModule(BazelStarlarkEnvironment.createNativeModule(uninjectedBuildBzlNativeBindings), BazelStarlarkEnvironment.createNativeModule(unwrappedBuildBzlSymbols), BazelStarlarkEnvironment.createNativeModule(ruleClassProvider.getStarlarkBuiltinsInternals()));
        Object conflictingValue = env.put("_builtins", builtinsModule);
        Preconditions.checkState(conflictingValue == null, "'_builtins' name is reserved for builtins injection");
        return ImmutableMap.copyOf(env);
    }

    private static void validateSymbolIsInjectable(String symbol, Set<String> existingSymbols, Set<String> injectableSymbols, String kind) throws InjectionException {
        if (!existingSymbols.contains(symbol)) {
            throw new InjectionException(String.format("Injected %s '%s' must override an existing one by that name", kind, symbol));
        }
        if (!injectableSymbols.contains(symbol)) {
            throw new InjectionException(String.format("Cannot override '%s' with an injected %s", symbol, kind));
        }
    }

    @Nullable
    private static Character getKeyPrefix(String key) {
        if (key.isEmpty()) {
            return null;
        }
        char prefix = key.charAt(0);
        if (prefix != '+' && prefix != '-') {
            return null;
        }
        return Character.valueOf(prefix);
    }

    private static String getKeySuffix(String key) {
        return BazelStarlarkEnvironment.getKeyPrefix(key) == null ? key : key.substring(1);
    }

    private static Map<String, Boolean> parseInjectionOverridesList(List<String> overrides) throws InjectionException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String prefixedItem : overrides) {
            Character prefix = BazelStarlarkEnvironment.getKeyPrefix(prefixedItem);
            if (prefix == null) {
                throw new InjectionException(String.format("Invalid injection override item: '%s'", prefixedItem));
            }
            result.put(prefixedItem.substring(1), prefix.charValue() == '+');
        }
        return result;
    }

    private static boolean injectionApplies(String key, Map<String, Boolean> overrides) {
        Character prefix = BazelStarlarkEnvironment.getKeyPrefix(key);
        if (prefix == null) {
            return true;
        }
        Boolean override = overrides.get(key.substring(1));
        if (override == null) {
            return prefix.charValue() == '+';
        }
        return override;
    }

    public ImmutableMap<String, Object> createBuildBzlEnvUsingInjection(Map<String, Object> exportedToplevels, Map<String, Object> exportedRules, List<String> overridesList) throws InjectionException {
        return this.createBzlEnvUsingInjection(exportedToplevels, exportedRules, overridesList, this.uninjectedBuildBzlNativeBindings);
    }

    public ImmutableMap<String, Object> createWorkspaceBzlEnvUsingInjection(Map<String, Object> exportedToplevels, Map<String, Object> exportedRules, List<String> overridesList) throws InjectionException {
        return this.createBzlEnvUsingInjection(exportedToplevels, exportedRules, overridesList, this.workspaceBzlNativeBindings);
    }

    private ImmutableMap<String, Object> createBzlEnvUsingInjection(Map<String, Object> exportedToplevels, Map<String, Object> exportedRules, List<String> overridesList, Map<String, Object> nativeBase) throws InjectionException {
        String name;
        String key;
        Map<String, Boolean> overridesMap = BazelStarlarkEnvironment.parseInjectionOverridesList(overridesList);
        HashMap<String, Object> env = new HashMap<String, Object>(this.ruleClassProvider.getEnvironment());
        HashMap<String, Object> nativeBindings = new HashMap<String, Object>(nativeBase);
        for (Map.Entry<String, Object> entry : exportedRules.entrySet()) {
            key = entry.getKey();
            name = BazelStarlarkEnvironment.getKeySuffix(key);
            BazelStarlarkEnvironment.validateSymbolIsInjectable(name, nativeBindings.keySet(), this.ruleFunctions.keySet(), "rule");
            if (!BazelStarlarkEnvironment.injectionApplies(key, overridesMap)) continue;
            nativeBindings.put(name, entry.getValue());
        }
        env.put("native", BazelStarlarkEnvironment.createNativeModule(nativeBindings));
        for (Map.Entry<String, Object> entry : exportedToplevels.entrySet()) {
            key = entry.getKey();
            name = BazelStarlarkEnvironment.getKeySuffix(key);
            BazelStarlarkEnvironment.validateSymbolIsInjectable(name, Sets.union(env.keySet(), Starlark.UNIVERSE.keySet()), this.ruleClassProvider.getNativeRuleSpecificBindings().keySet(), "top-level symbol");
            if (!BazelStarlarkEnvironment.injectionApplies(key, overridesMap)) continue;
            env.put(name, entry.getValue());
        }
        return ImmutableMap.copyOf(env);
    }

    public ImmutableMap<String, Object> createBuildEnvUsingInjection(Map<String, Object> exportedRules, List<String> overridesList) throws InjectionException {
        Map<String, Boolean> overridesMap = BazelStarlarkEnvironment.parseInjectionOverridesList(overridesList);
        HashMap<String, Object> env = new HashMap<String, Object>(this.uninjectedBuildEnv);
        for (Map.Entry<String, Object> entry : exportedRules.entrySet()) {
            String key = entry.getKey();
            String name = BazelStarlarkEnvironment.getKeySuffix(key);
            BazelStarlarkEnvironment.validateSymbolIsInjectable(name, Sets.union(env.keySet(), Starlark.UNIVERSE.keySet()), this.ruleFunctions.keySet(), "rule");
            if (!BazelStarlarkEnvironment.injectionApplies(key, overridesMap)) continue;
            env.put(name, entry.getValue());
        }
        return ImmutableMap.copyOf(env);
    }

    public static final class InjectionException
    extends Exception {
        InjectionException(String message) {
            super(message);
        }
    }
}

