/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.analysis.RuleDefinitionEnvironment;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.packages.SymbolGenerator;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;

public class BazelStarlarkContext
implements RuleDefinitionEnvironment,
StarlarkThread.UncheckedExceptionContext {
    private final SymbolGenerator<?> symbolGenerator;
    private final Phase phase;
    @Nullable
    private final RepositoryName toolsRepository;
    @Nullable
    private final ImmutableMap<String, Class<?>> fragmentNameToClass;
    @Nullable
    private final Label analysisRuleLabel;
    @Nullable
    private final Label networkAllowlistForTests;

    public static BazelStarlarkContext from(StarlarkThread thread) {
        BazelStarlarkContext ctx = thread.getThreadLocal(BazelStarlarkContext.class);
        Preconditions.checkState(ctx != null, "Expected BazelStarlarkContext to be available in this Starlark thread");
        return ctx;
    }

    public void storeInThread(StarlarkThread thread) {
        Preconditions.checkState(thread.getThreadLocal(BazelStarlarkContext.class) == null);
        thread.setThreadLocal(BazelStarlarkContext.class, this);
        thread.setUncheckedExceptionContext(this);
    }

    public BazelStarlarkContext(Phase phase, @Nullable RepositoryName toolsRepository, @Nullable ImmutableMap<String, Class<?>> fragmentNameToClass, SymbolGenerator<?> symbolGenerator, @Nullable Label analysisRuleLabel, @Nullable Label networkAllowlistForTests) {
        this.phase = Preconditions.checkNotNull(phase);
        this.toolsRepository = toolsRepository;
        this.fragmentNameToClass = fragmentNameToClass;
        this.symbolGenerator = Preconditions.checkNotNull(symbolGenerator);
        this.analysisRuleLabel = analysisRuleLabel;
        this.networkAllowlistForTests = networkAllowlistForTests;
    }

    public Phase getPhase() {
        return this.phase;
    }

    @Override
    @Nullable
    public RepositoryName getToolsRepository() {
        return this.toolsRepository;
    }

    @Nullable
    public ImmutableMap<String, Class<?>> getFragmentNameToClass() {
        return this.fragmentNameToClass;
    }

    public SymbolGenerator<?> getSymbolGenerator() {
        return this.symbolGenerator;
    }

    @Nullable
    public Label getAnalysisRuleLabel() {
        return this.analysisRuleLabel;
    }

    @Override
    public String getContextForUncheckedException() {
        return ((Serializable)((Object)MoreObjects.firstNonNull(this.analysisRuleLabel, this.phase))).toString();
    }

    @Override
    public Optional<Label> getNetworkAllowlistForTests() {
        return Optional.ofNullable(this.networkAllowlistForTests);
    }

    public void checkLoadingOrWorkspacePhase(String function) throws EvalException {
        if (this.phase == Phase.ANALYSIS) {
            throw Starlark.errorf("'%s' cannot be called during the analysis phase", function);
        }
    }

    public void checkLoadingPhase(String function) throws EvalException {
        if (this.phase != Phase.LOADING) {
            throw Starlark.errorf("'%s' can only be called during the loading phase", function);
        }
    }

    public void checkWorkspacePhase(String function) throws EvalException {
        if (this.phase != Phase.WORKSPACE) {
            throw Starlark.errorf("'%s' can only be called during workspace loading", function);
        }
    }

    public static enum Phase {
        WORKSPACE,
        LOADING,
        ANALYSIS;

    }
}

