/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public enum AttributeValueSource {
    NATIVE_COMPUTED_DEFAULT("$", false),
    COMPUTED_DEFAULT("$", true),
    LATE_BOUND(":", true),
    DIRECT("$", false);

    private static final String STARLARK_PREFIX = "_";
    private final String nativePrefix;
    private final boolean mustHaveStarlarkPrefix;

    private AttributeValueSource(String nativePrefix, boolean mustHaveStarlarkPrefix) {
        this.nativePrefix = nativePrefix;
        this.mustHaveStarlarkPrefix = mustHaveStarlarkPrefix;
    }

    public void validateStarlarkName(String attrStarlarkName) throws EvalException {
        if (attrStarlarkName.isEmpty()) {
            throw new EvalException("Attribute name must not be empty.");
        }
        if (this.mustHaveStarlarkPrefix && !attrStarlarkName.startsWith(STARLARK_PREFIX)) {
            throw Starlark.errorf("When an attribute value is a function, the attribute must be private (i.e. start with '%s'). Found '%s'", STARLARK_PREFIX, attrStarlarkName);
        }
    }

    public String convertToNativeName(String attrStarlarkName) throws EvalException {
        this.validateStarlarkName(attrStarlarkName);
        return attrStarlarkName.startsWith(STARLARK_PREFIX) ? this.nativePrefix + attrStarlarkName.substring(STARLARK_PREFIX.length()) : attrStarlarkName;
    }
}

