/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.ProtoUtils;
import com.google.devtools.build.lib.packages.TriState;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.query2.proto.proto2api.Build;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.StarlarkInt;

public class AttributeFormatter {
    private static final ImmutableSet<Type<?>> depTypes = ImmutableSet.of(Type.STRING, BuildType.LABEL, BuildType.OUTPUT, Type.STRING_LIST, BuildType.LABEL_LIST, BuildType.LABEL_DICT_UNARY, new Type[]{BuildType.LABEL_KEYED_STRING_DICT, BuildType.OUTPUT_LIST, BuildType.DISTRIBUTIONS});
    private static final ImmutableSet<Type<?>> noDepTypes = ImmutableSet.of(BuildType.NODEP_LABEL_LIST, BuildType.NODEP_LABEL);

    private AttributeFormatter() {
    }

    public static Build.Attribute getAttributeProto(Attribute attr, @Nullable Object value, boolean explicitlySpecified, boolean encodeBooleanAndTriStateAsIntegerAndString) {
        return AttributeFormatter.getAttributeProto(attr.getName(), attr.getType(), value, explicitlySpecified, encodeBooleanAndTriStateAsIntegerAndString);
    }

    private static Build.Attribute getAttributeProto(String name, Type<?> type, @Nullable Object value, boolean explicitlySpecified, boolean encodeBooleanAndTriStateAsIntegerAndString) {
        Build.Attribute.Builder attrPb = Build.Attribute.newBuilder();
        attrPb.setName(name);
        attrPb.setExplicitlySpecified(explicitlySpecified);
        AttributeFormatter.maybeSetNoDep(type, attrPb);
        if (value instanceof BuildType.SelectorList) {
            attrPb.setType(Build.Attribute.Discriminator.SELECTOR_LIST);
            AttributeFormatter.writeSelectorListToBuilder(attrPb, type, (BuildType.SelectorList)value);
        } else {
            attrPb.setType(ProtoUtils.getDiscriminatorFromType(type));
            if (value != null) {
                AttributeBuilderAdapter adapter = new AttributeBuilderAdapter(attrPb, encodeBooleanAndTriStateAsIntegerAndString);
                AttributeFormatter.writeAttributeValueToBuilder(adapter, type, value);
            }
        }
        return attrPb.build();
    }

    private static void maybeSetNoDep(Type<?> type, Build.Attribute.Builder attrPb) {
        if (depTypes.contains(type)) {
            attrPb.setNodep(false);
        } else if (noDepTypes.contains(type)) {
            attrPb.setNodep(true);
        }
    }

    private static void writeSelectorListToBuilder(Build.Attribute.Builder attrPb, Type<?> type, BuildType.SelectorList<?> selectorList) {
        Build.Attribute.SelectorList.Builder selectorListBuilder = Build.Attribute.SelectorList.newBuilder();
        selectorListBuilder.setType(ProtoUtils.getDiscriminatorFromType(type));
        for (BuildType.Selector<?> selector : selectorList.getSelectors()) {
            Build.Attribute.Selector.Builder selectorBuilder = Build.Attribute.Selector.newBuilder().setNoMatchError(selector.getNoMatchError()).setHasDefaultValue(selector.hasDefault());
            selector.forEach((condition, conditionValue) -> {
                Build.Attribute.SelectorEntry.Builder selectorEntryBuilder = Build.Attribute.SelectorEntry.newBuilder().setLabel(condition.toString()).setIsDefaultValue(!selector.isValueSet(condition));
                if (conditionValue != null) {
                    AttributeFormatter.writeAttributeValueToBuilder(new SelectorEntryBuilderAdapter(selectorEntryBuilder), type, conditionValue);
                }
                selectorBuilder.addEntries(selectorEntryBuilder);
            });
            selectorListBuilder.addElements(selectorBuilder);
        }
        attrPb.setSelectorList(selectorListBuilder);
    }

    private static void writeAttributeValueToBuilder(AttributeValueBuilderAdapter builder, Type<?> type, Object value) {
        if (type == Type.INTEGER) {
            builder.setIntValue(((StarlarkInt)value).toIntUnchecked());
        } else if (type == Type.STRING || type == BuildType.LABEL || type == BuildType.NODEP_LABEL || type == BuildType.OUTPUT || type == BuildType.GENQUERY_SCOPE_TYPE) {
            builder.setStringValue(value.toString());
        } else if (type == Type.STRING_LIST || type == BuildType.LABEL_LIST || type == BuildType.NODEP_LABEL_LIST || type == BuildType.OUTPUT_LIST || type == BuildType.DISTRIBUTIONS || type == BuildType.GENQUERY_SCOPE_TYPE_LIST) {
            for (Object entry : (Collection)value) {
                builder.addStringListValue(entry.toString());
            }
        } else if (type == Type.INTEGER_LIST) {
            for (Object elem : (Collection)value) {
                builder.addIntListValue(((StarlarkInt)elem).toIntUnchecked());
            }
        } else if (type == Type.BOOLEAN) {
            builder.setBooleanValue((Boolean)value);
        } else if (type == BuildType.TRISTATE) {
            builder.setTristateValue(AttributeFormatter.triStateToProto((TriState)((Object)value)));
        } else if (type == BuildType.LICENSE) {
            License license = (License)value;
            Build.License.Builder licensePb = Build.License.newBuilder();
            for (License.LicenseType licenseType : license.getLicenseTypes()) {
                licensePb.addLicenseType(licenseType.toString());
            }
            for (Label exception : license.getExceptions()) {
                licensePb.addException(exception.toString());
            }
            builder.setLicense(licensePb);
        } else if (type == Type.STRING_DICT) {
            Map dict = (Map)value;
            for (Map.Entry keyValueList : dict.entrySet()) {
                Build.StringDictEntry.Builder entry = Build.StringDictEntry.newBuilder().setKey((String)keyValueList.getKey()).setValue((String)keyValueList.getValue());
                builder.addStringDictValue(entry);
            }
        } else if (type == Type.STRING_LIST_DICT) {
            Map dict = (Map)value;
            for (Map.Entry dictEntry : dict.entrySet()) {
                Build.StringListDictEntry.Builder entry = Build.StringListDictEntry.newBuilder().setKey((String)dictEntry.getKey());
                for (Object dictEntryValue : (List)dictEntry.getValue()) {
                    entry.addValue(dictEntryValue.toString());
                }
                builder.addStringListDictValue(entry);
            }
        } else if (type == BuildType.LABEL_DICT_UNARY) {
            Map dict = (Map)value;
            for (Map.Entry dictEntry : dict.entrySet()) {
                Build.LabelDictUnaryEntry.Builder entry = Build.LabelDictUnaryEntry.newBuilder().setKey((String)dictEntry.getKey()).setValue(((Label)dictEntry.getValue()).toString());
                builder.addLabelDictUnaryValue(entry);
            }
        } else if (type == BuildType.LABEL_KEYED_STRING_DICT) {
            Map dict = (Map)value;
            for (Map.Entry dictEntry : dict.entrySet()) {
                Build.LabelKeyedStringDictEntry.Builder entry = Build.LabelKeyedStringDictEntry.newBuilder().setKey(((Label)dictEntry.getKey()).toString()).setValue((String)dictEntry.getValue());
                builder.addLabelKeyedStringDictValue(entry);
            }
        } else {
            throw new AssertionError((Object)("Unknown type: " + type));
        }
    }

    private static Build.Attribute.Tristate triStateToProto(TriState value) {
        switch (value) {
            case AUTO: {
                return Build.Attribute.Tristate.AUTO;
            }
            case NO: {
                return Build.Attribute.Tristate.NO;
            }
            case YES: {
                return Build.Attribute.Tristate.YES;
            }
        }
        throw new AssertionError((Object)"Expected AUTO/NO/YES to cover all possible cases");
    }

    private static class SelectorEntryBuilderAdapter
    implements AttributeValueBuilderAdapter {
        private final Build.Attribute.SelectorEntry.Builder selectorEntryBuilder;

        private SelectorEntryBuilderAdapter(Build.Attribute.SelectorEntry.Builder selectorEntryBuilder) {
            this.selectorEntryBuilder = Preconditions.checkNotNull(selectorEntryBuilder);
        }

        @Override
        public void addStringListValue(String s2) {
            this.selectorEntryBuilder.addStringListValue(s2);
        }

        @Override
        public void addLabelDictUnaryValue(Build.LabelDictUnaryEntry.Builder builder) {
            this.selectorEntryBuilder.addLabelDictUnaryValue(builder);
        }

        @Override
        public void addLabelKeyedStringDictValue(Build.LabelKeyedStringDictEntry.Builder builder) {
            this.selectorEntryBuilder.addLabelKeyedStringDictValue(builder);
        }

        @Override
        public void addIntListValue(int i) {
            this.selectorEntryBuilder.addIntListValue(i);
        }

        @Override
        public void addStringDictValue(Build.StringDictEntry.Builder builder) {
            this.selectorEntryBuilder.addStringDictValue(builder);
        }

        @Override
        public void addStringListDictValue(Build.StringListDictEntry.Builder builder) {
            this.selectorEntryBuilder.addStringListDictValue(builder);
        }

        @Override
        public void setBooleanValue(boolean b) {
            this.selectorEntryBuilder.setBooleanValue(b);
        }

        @Override
        public void setIntValue(int i) {
            this.selectorEntryBuilder.setIntValue(i);
        }

        @Override
        public void setLicense(Build.License.Builder builder) {
            this.selectorEntryBuilder.setLicense(builder);
        }

        @Override
        public void setStringValue(String s2) {
            this.selectorEntryBuilder.setStringValue(s2);
        }

        @Override
        public void setTristateValue(Build.Attribute.Tristate tristate) {
            this.selectorEntryBuilder.setTristateValue(tristate);
        }
    }

    private static class AttributeBuilderAdapter
    implements AttributeValueBuilderAdapter {
        private final boolean encodeBooleanAndTriStateAsIntegerAndString;
        private final Build.Attribute.Builder attributeBuilder;

        private AttributeBuilderAdapter(Build.Attribute.Builder attributeBuilder, boolean encodeBooleanAndTriStateAsIntegerAndString) {
            this.attributeBuilder = Preconditions.checkNotNull(attributeBuilder);
            this.encodeBooleanAndTriStateAsIntegerAndString = encodeBooleanAndTriStateAsIntegerAndString;
        }

        @Override
        public void addStringListValue(String s2) {
            this.attributeBuilder.addStringListValue(s2);
        }

        @Override
        public void addLabelDictUnaryValue(Build.LabelDictUnaryEntry.Builder builder) {
            this.attributeBuilder.addLabelDictUnaryValue(builder);
        }

        @Override
        public void addLabelKeyedStringDictValue(Build.LabelKeyedStringDictEntry.Builder builder) {
            this.attributeBuilder.addLabelKeyedStringDictValue(builder);
        }

        @Override
        public void addIntListValue(int i) {
            this.attributeBuilder.addIntListValue(i);
        }

        @Override
        public void addStringDictValue(Build.StringDictEntry.Builder builder) {
            this.attributeBuilder.addStringDictValue(builder);
        }

        @Override
        public void addStringListDictValue(Build.StringListDictEntry.Builder builder) {
            this.attributeBuilder.addStringListDictValue(builder);
        }

        @Override
        public void setBooleanValue(boolean b) {
            if (b) {
                this.attributeBuilder.setBooleanValue(true);
                if (this.encodeBooleanAndTriStateAsIntegerAndString) {
                    this.attributeBuilder.setStringValue("true");
                    this.attributeBuilder.setIntValue(1);
                }
            } else {
                this.attributeBuilder.setBooleanValue(false);
                if (this.encodeBooleanAndTriStateAsIntegerAndString) {
                    this.attributeBuilder.setStringValue("false");
                    this.attributeBuilder.setIntValue(0);
                }
            }
        }

        @Override
        public void setIntValue(int i) {
            this.attributeBuilder.setIntValue(i);
        }

        @Override
        public void setLicense(Build.License.Builder builder) {
            this.attributeBuilder.setLicense(builder);
        }

        @Override
        public void setStringValue(String s2) {
            this.attributeBuilder.setStringValue(s2);
        }

        @Override
        public void setTristateValue(Build.Attribute.Tristate tristate) {
            switch (tristate) {
                case AUTO: {
                    this.attributeBuilder.setTristateValue(Build.Attribute.Tristate.AUTO);
                    if (!this.encodeBooleanAndTriStateAsIntegerAndString) break;
                    this.attributeBuilder.setIntValue(-1);
                    this.attributeBuilder.setStringValue("auto");
                    break;
                }
                case NO: {
                    this.attributeBuilder.setTristateValue(Build.Attribute.Tristate.NO);
                    if (!this.encodeBooleanAndTriStateAsIntegerAndString) break;
                    this.attributeBuilder.setIntValue(0);
                    this.attributeBuilder.setStringValue("no");
                    break;
                }
                case YES: {
                    this.attributeBuilder.setTristateValue(Build.Attribute.Tristate.YES);
                    if (!this.encodeBooleanAndTriStateAsIntegerAndString) break;
                    this.attributeBuilder.setIntValue(1);
                    this.attributeBuilder.setStringValue("yes");
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Expected AUTO/NO/YES to cover all possible cases");
                }
            }
        }
    }

    private static interface AttributeValueBuilderAdapter {
        public void addStringListValue(String var1);

        public void addLabelDictUnaryValue(Build.LabelDictUnaryEntry.Builder var1);

        public void addLabelKeyedStringDictValue(Build.LabelKeyedStringDictEntry.Builder var1);

        public void addIntListValue(int var1);

        public void addStringDictValue(Build.StringDictEntry.Builder var1);

        public void addStringListDictValue(Build.StringListDictEntry.Builder var1);

        public void setBooleanValue(boolean var1);

        public void setIntValue(int var1);

        public void setLicense(Build.License.Builder var1);

        public void setStringValue(String var1);

        public void setTristateValue(Build.Attribute.Tristate var1);
    }
}

