/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.analysis.TransitiveInfoProvider;
import com.google.devtools.build.lib.analysis.config.transitions.NoTransition;
import com.google.devtools.build.lib.analysis.config.transitions.TransitionFactory;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.Aspect;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.devtools.build.lib.packages.AspectsListBuilder;
import com.google.devtools.build.lib.packages.AttributeMap;
import com.google.devtools.build.lib.packages.AttributeTransitionData;
import com.google.devtools.build.lib.packages.AttributeValueSource;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.LabelConverter;
import com.google.devtools.build.lib.packages.NativeAspectClass;
import com.google.devtools.build.lib.packages.PredicateWithMessage;
import com.google.devtools.build.lib.packages.RequiredProviders;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.StarlarkCallbackHelper;
import com.google.devtools.build.lib.packages.StarlarkInfo;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.packages.StructProvider;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.starlarkbuildapi.NativeComputedDefaultApi;
import com.google.devtools.build.lib.util.FileType;
import com.google.devtools.build.lib.util.FileTypeSet;
import com.google.devtools.build.lib.util.StringUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkValue;

@Immutable
public final class Attribute
implements Comparable<Attribute> {
    public static final RuleClass.Builder.RuleClassNamePredicate ANY_RULE = RuleClass.Builder.RuleClassNamePredicate.unspecified();
    private static final RuleClass.Builder.RuleClassNamePredicate NO_RULE = RuleClass.Builder.RuleClassNamePredicate.only(new String[0]);
    @SerializationConstant
    public static final ValidityPredicate ANY_EDGE = (from, toRuleClass, toRuleTags) -> null;
    private static final ComputationLimiter<RuntimeException> NULL_COMPUTATION_LIMITER = count -> {};
    private final String name;
    private final String doc;
    private final Type<?> type;
    private final Set<PropertyFlag> propertyFlags;
    private final Object defaultValue;
    private final TransitionFactory<AttributeTransitionData> transitionFactory;
    private final RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabels;
    private final RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabelsWarning;
    private final FileTypeSet allowedFileTypesForLabels;
    private final ValidityPredicate validityPredicate;
    private final PredicateWithMessage<Object> allowedValues;
    private final RequiredProviders requiredProviders;
    private final ImmutableList<AspectsListBuilder.AspectDetails<?>> aspects;
    private final int hashCode;

    public static <TYPE> Builder<TYPE> attr(String name, Type<TYPE> type) {
        return new Builder<TYPE>(name, type);
    }

    private Attribute(String name, String doc, Type<?> type, Set<PropertyFlag> propertyFlags, Object defaultValue, TransitionFactory<AttributeTransitionData> transitionFactory, RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabels, RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabelsWarning, FileTypeSet allowedFileTypesForLabels, ValidityPredicate validityPredicate, PredicateWithMessage<Object> allowedValues, RequiredProviders requiredProviders, ImmutableList<AspectsListBuilder.AspectDetails<?>> aspects) {
        Preconditions.checkArgument(NoTransition.isInstance(transitionFactory) || type.getLabelClass() == Type.LabelClass.DEPENDENCY || type.getLabelClass() == Type.LabelClass.NONDEP_REFERENCE, "Configuration transitions can only be specified for label or label list attributes");
        Preconditions.checkArgument(Attribute.isLateBound(name) == defaultValue instanceof LateBoundDefault, "late bound attributes require a default value that is late bound (and vice versa): %s", (Object)name);
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.propertyFlags = propertyFlags;
        this.defaultValue = defaultValue;
        this.transitionFactory = transitionFactory;
        this.allowedRuleClassesForLabels = allowedRuleClassesForLabels;
        this.allowedRuleClassesForLabelsWarning = allowedRuleClassesForLabelsWarning;
        this.allowedFileTypesForLabels = allowedFileTypesForLabels;
        this.validityPredicate = validityPredicate;
        this.allowedValues = allowedValues;
        this.requiredProviders = requiredProviders;
        this.aspects = aspects;
        this.hashCode = Objects.hash(name, doc, type, propertyFlags, defaultValue, transitionFactory, allowedRuleClassesForLabels, allowedRuleClassesForLabelsWarning, allowedFileTypesForLabels, validityPredicate, allowedValues, requiredProviders, aspects);
    }

    public String getName() {
        return this.name;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getPublicName() {
        return Attribute.getStarlarkName(this.name);
    }

    public Type<?> getType() {
        return this.type;
    }

    private boolean getPropertyFlag(PropertyFlag flag) {
        return this.propertyFlags.contains((Object)flag);
    }

    public boolean isMandatory() {
        return this.getPropertyFlag(PropertyFlag.MANDATORY);
    }

    public boolean isNonEmpty() {
        return this.getPropertyFlag(PropertyFlag.NON_EMPTY);
    }

    public boolean isSingleArtifact() {
        return this.getPropertyFlag(PropertyFlag.SINGLE_ARTIFACT);
    }

    public boolean isSilentRuleClassFilter() {
        return this.getPropertyFlag(PropertyFlag.SILENT_RULECLASS_FILTER);
    }

    public boolean isSkipAnalysisTimeFileTypeCheck() {
        return this.getPropertyFlag(PropertyFlag.SKIP_ANALYSIS_TIME_FILETYPE_CHECK);
    }

    public boolean isOrderIndependent() {
        return this.getPropertyFlag(PropertyFlag.ORDER_INDEPENDENT);
    }

    public boolean useOutputLicenses() {
        return this.getPropertyFlag(PropertyFlag.OUTPUT_LICENSES);
    }

    public boolean hasStarlarkDefinedTransition() {
        return this.getPropertyFlag(PropertyFlag.HAS_STARLARK_DEFINED_TRANSITION);
    }

    public boolean hasAnalysisTestTransition() {
        return this.getPropertyFlag(PropertyFlag.HAS_ANALYSIS_TEST_TRANSITION);
    }

    public TransitionFactory<AttributeTransitionData> getTransitionFactory() {
        return this.transitionFactory;
    }

    public boolean isExecutable() {
        return this.getPropertyFlag(PropertyFlag.EXECUTABLE);
    }

    public boolean isDirectCompileTimeInput() {
        return this.getPropertyFlag(PropertyFlag.DIRECT_COMPILE_TIME_INPUT);
    }

    public boolean isDocumented() {
        return !this.getPropertyFlag(PropertyFlag.UNDOCUMENTED);
    }

    public boolean isTaggable() {
        return this.getPropertyFlag(PropertyFlag.TAGGABLE);
    }

    public boolean isStrictLabelCheckingEnabled() {
        return this.getPropertyFlag(PropertyFlag.STRICT_LABEL_CHECKING);
    }

    public boolean checkAllowedValues() {
        return this.getPropertyFlag(PropertyFlag.CHECK_ALLOWED_VALUES);
    }

    public boolean performPrereqValidatorCheck() {
        return !this.getPropertyFlag(PropertyFlag.SKIP_PREREQ_VALIDATOR_CHECKS);
    }

    public boolean checkConstraintsOverride() {
        return this.getPropertyFlag(PropertyFlag.CHECK_CONSTRAINTS_OVERRIDE);
    }

    public boolean skipConstraintsOverride() {
        return this.getPropertyFlag(PropertyFlag.SKIP_CONSTRAINTS_OVERRIDE);
    }

    public boolean isConfigurable() {
        return this.type.getLabelClass() != Type.LabelClass.OUTPUT && !this.getPropertyFlag(PropertyFlag.NONCONFIGURABLE);
    }

    public boolean isToolDependency() {
        if (this.type.getLabelClass() != Type.LabelClass.DEPENDENCY) {
            return false;
        }
        if (this.getPropertyFlag(PropertyFlag.IS_TOOL_DEPENDENCY)) {
            return true;
        }
        return this.transitionFactory.isTool();
    }

    public boolean starlarkDefined() {
        return this.getPropertyFlag(PropertyFlag.STARLARK_DEFINED);
    }

    public Predicate<RuleClass> getAllowedRuleClassObjectPredicate() {
        return this.allowedRuleClassesForLabels.asPredicateOfRuleClassObject();
    }

    public Predicate<String> getAllowedRuleClassPredicate() {
        return this.allowedRuleClassesForLabels.asPredicateOfRuleClass();
    }

    public Predicate<RuleClass> getAllowedRuleClassObjectWarningPredicate() {
        return this.allowedRuleClassesForLabelsWarning.asPredicateOfRuleClassObject();
    }

    public Predicate<String> getAllowedRuleClassWarningPredicate() {
        return this.allowedRuleClassesForLabelsWarning.asPredicateOfRuleClass();
    }

    public RequiredProviders getRequiredProviders() {
        return this.requiredProviders;
    }

    public FileTypeSet getAllowedFileTypesPredicate() {
        return this.allowedFileTypesForLabels;
    }

    public ValidityPredicate getValidityPredicate() {
        return this.validityPredicate;
    }

    public PredicateWithMessage<Object> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean hasAspects() {
        return !this.aspects.isEmpty();
    }

    public ImmutableList<Aspect> getAspects(Rule rule) {
        if (this.aspects.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = null;
        for (AspectsListBuilder.AspectDetails aspectDetails : this.aspects) {
            Aspect a = aspectDetails.getAspect(rule);
            if (a == null) continue;
            if (builder == null) {
                builder = ImmutableList.builder();
            }
            builder.add(a);
        }
        return builder == null ? ImmutableList.of() : builder.build();
    }

    public ImmutableList<AspectClass> getAspectClasses() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (AspectsListBuilder.AspectDetails aspectDetails : this.aspects) {
            result.add(aspectDetails.getAspectClass());
        }
        return result.build();
    }

    public ImmutableList<AspectsListBuilder.AspectDetails<?>> getAspectsDetails() {
        return this.aspects;
    }

    @Nullable
    public Object getDefaultValue() {
        if (this.defaultValue instanceof LateBoundDefault) {
            return ((LateBoundDefault)this.defaultValue).getDefault();
        }
        return this.defaultValue;
    }

    public Object getDefaultValueUnchecked() {
        return this.defaultValue;
    }

    public LateBoundDefault<?, ?> getLateBoundDefault() {
        Preconditions.checkState(this.isLateBound());
        return (LateBoundDefault)this.defaultValue;
    }

    boolean hasComputedDefault() {
        return this.defaultValue instanceof ComputedDefault || this.defaultValue instanceof StarlarkComputedDefaultTemplate;
    }

    public boolean isImplicit() {
        return Attribute.isImplicit(this.name);
    }

    public static boolean isImplicit(String name) {
        return name.startsWith("$");
    }

    public boolean isLateBound() {
        return Attribute.isLateBound(this.name);
    }

    public static boolean isLateBound(String name) {
        return name.startsWith(":");
    }

    private static boolean isPrivateAttribute(String nativeAttrName) {
        return Attribute.isLateBound(nativeAttrName) || Attribute.isImplicit(nativeAttrName);
    }

    public static String getStarlarkName(String nativeAttrName) {
        if (Attribute.isPrivateAttribute(nativeAttrName)) {
            return "_" + nativeAttrName.substring(1);
        }
        return nativeAttrName;
    }

    public String toString() {
        return "Attribute(" + this.name + ", " + this.type + ")";
    }

    @Override
    public int compareTo(Attribute other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.hashCode == attribute.hashCode && Objects.equals(this.name, attribute.name) && Objects.equals(this.doc, attribute.doc) && Objects.equals(this.type, attribute.type) && Objects.equals(this.propertyFlags, attribute.propertyFlags) && Objects.equals(this.defaultValue, attribute.defaultValue) && Objects.equals(this.transitionFactory, attribute.transitionFactory) && Objects.equals(this.allowedRuleClassesForLabels, attribute.allowedRuleClassesForLabels) && Objects.equals(this.allowedRuleClassesForLabelsWarning, attribute.allowedRuleClassesForLabelsWarning) && Objects.equals(this.allowedFileTypesForLabels, attribute.allowedFileTypesForLabels) && Objects.equals(this.validityPredicate, attribute.validityPredicate) && Objects.equals(this.allowedValues, attribute.allowedValues) && Objects.equals(this.requiredProviders, attribute.requiredProviders) && Objects.equals(this.aspects, attribute.aspects);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public <TYPE> Builder<TYPE> cloneBuilder(Type<TYPE> tp) {
        Preconditions.checkArgument(tp == this.type);
        Builder<TYPE> builder = new Builder<TYPE>(this.name, tp);
        builder.doc = this.doc;
        builder.allowedFileTypesForLabels = this.allowedFileTypesForLabels;
        builder.allowedRuleClassesForLabels = this.allowedRuleClassesForLabels;
        builder.allowedRuleClassesForLabelsWarning = this.allowedRuleClassesForLabelsWarning;
        builder.requiredProvidersBuilder = this.requiredProviders.copyAsBuilder();
        builder.validityPredicate = this.validityPredicate;
        builder.transitionFactory = this.transitionFactory;
        builder.propertyFlags = Sets.newEnumSet(this.propertyFlags, PropertyFlag.class);
        builder.value = this.defaultValue;
        builder.valueSet = false;
        builder.allowedValues = this.allowedValues;
        builder.aspectsListBuilder = new AspectsListBuilder(this.aspects);
        return builder;
    }

    public Builder<?> cloneBuilder() {
        return this.cloneBuilder(this.type);
    }

    public static Object valueToStarlark(Object x) {
        Map map;
        if (x instanceof Map && !(map = (Map)x).isEmpty() && map.values().iterator().next() instanceof List) {
            Dict.Builder dict = Dict.builder();
            for (Map.Entry e : map.entrySet()) {
                dict.put(e.getKey(), Starlark.fromJava(e.getValue(), null));
            }
            return dict.buildImmutable();
        }
        return Starlark.fromJava(x, null);
    }

    public static class LabelListLateBoundDefault<FragmentT>
    extends SimpleLateBoundDefault<FragmentT, List<Label>> {
        private LabelListLateBoundDefault(Class<FragmentT> fragmentClass, LateBoundDefault.Resolver<FragmentT, List<Label>> resolver) {
            super(fragmentClass, ImmutableList.of(), resolver);
        }

        public static <FragmentT> LabelListLateBoundDefault<FragmentT> fromTargetConfiguration(Class<FragmentT> fragmentClass, LateBoundDefault.Resolver<FragmentT, List<Label>> resolver) {
            Preconditions.checkArgument(!fragmentClass.equals(Void.class), "Use fromRuleAndAttributesOnly to specify a LateBoundDefault which does not use configuration.");
            return new LabelListLateBoundDefault<FragmentT>(fragmentClass, resolver);
        }

        public static LabelListLateBoundDefault<Void> fromRuleAndAttributesOnly(LateBoundDefault.Resolver<Void, List<Label>> resolver) {
            return new LabelListLateBoundDefault<Void>(Void.class, resolver);
        }
    }

    public static class LabelLateBoundDefault<FragmentT>
    extends SimpleLateBoundDefault<FragmentT, Label> {
        @VisibleForTesting
        protected LabelLateBoundDefault(Class<FragmentT> fragmentClass, Label defaultValue, LateBoundDefault.Resolver<FragmentT, Label> resolver) {
            super(fragmentClass, defaultValue, resolver);
        }

        public static <FragmentT> LabelLateBoundDefault<FragmentT> fromTargetConfiguration(Class<FragmentT> fragmentClass, Label defaultValue, LateBoundDefault.Resolver<FragmentT, Label> resolver) {
            Preconditions.checkArgument(!fragmentClass.equals(Void.class), "Use fromRuleAndAttributesOnly to specify a LateBoundDefault which does not use configuration.");
            return new LabelLateBoundDefault<FragmentT>(fragmentClass, defaultValue, resolver);
        }
    }

    @AutoCodec.VisibleForSerialization
    static class AlwaysNullLateBoundDefault
    extends SimpleLateBoundDefault<Void, Void> {
        @SerializationConstant
        @AutoCodec.VisibleForSerialization
        static final AlwaysNullLateBoundDefault INSTANCE = new AlwaysNullLateBoundDefault();

        private AlwaysNullLateBoundDefault() {
            super(Void.class, null, (rule, attributes, unused) -> null);
        }
    }

    public static abstract class AbstractLabelLateBoundDefault<FragmentT>
    extends LateBoundDefault<FragmentT, Label> {
        protected AbstractLabelLateBoundDefault(Class<FragmentT> fragmentClass, Label defaultValue) {
            super(fragmentClass, defaultValue);
        }
    }

    @Immutable
    public static abstract class LateBoundDefault<FragmentT, ValueT>
    implements StarlarkValue {
        private final ValueT defaultValue;
        private final Class<FragmentT> fragmentClass;

        @VisibleForTesting
        public static LabelLateBoundDefault<Void> fromConstantForTesting(Label defaultValue) {
            return new LabelLateBoundDefault<Void>(Void.class, Preconditions.checkNotNull(defaultValue), (rule, attributes, unused) -> defaultValue){};
        }

        public static <ValueT> LateBoundDefault<Void, ValueT> alwaysNull() {
            return AlwaysNullLateBoundDefault.INSTANCE;
        }

        LateBoundDefault(Class<FragmentT> fragmentClass, ValueT defaultValue) {
            this.defaultValue = defaultValue;
            this.fragmentClass = fragmentClass;
        }

        public final Class<FragmentT> getFragmentClass() {
            return this.fragmentClass;
        }

        public final ValueT getDefault() {
            return this.defaultValue;
        }

        public abstract ValueT resolve(Rule var1, AttributeMap var2, FragmentT var3);

        @FunctionalInterface
        public static interface Resolver<FragmentT, ValueT> {
            public ValueT resolve(Rule var1, AttributeMap var2, FragmentT var3);
        }
    }

    static class SimpleLateBoundDefault<FragmentT, ValueT>
    extends LateBoundDefault<FragmentT, ValueT> {
        private final LateBoundDefault.Resolver<FragmentT, ValueT> resolver;

        private SimpleLateBoundDefault(Class<FragmentT> fragmentClass, ValueT defaultValue, LateBoundDefault.Resolver<FragmentT, ValueT> resolver) {
            super(fragmentClass, defaultValue);
            this.resolver = resolver;
        }

        @Override
        public ValueT resolve(Rule rule, AttributeMap attributes, FragmentT input) {
            return this.resolver.resolve(rule, attributes, input);
        }
    }

    static final class StarlarkComputedDefault
    extends ComputedDefault {
        private final ImmutableList<Type<?>> dependencyTypes;
        private final Map<List<Object>, Object> lookupTable;

        StarlarkComputedDefault(ImmutableList<String> dependencies, ImmutableList<Type<?>> dependencyTypes, Map<List<Object>, Object> lookupTable) {
            super(Preconditions.checkNotNull(dependencies));
            this.dependencyTypes = Preconditions.checkNotNull(dependencyTypes);
            this.lookupTable = Preconditions.checkNotNull(lookupTable);
        }

        ImmutableList<Type<?>> getDependencyTypes() {
            return this.dependencyTypes;
        }

        Map<List<Object>, Object> getLookupTable() {
            return this.lookupTable;
        }

        @Override
        public Object getDefault(AttributeMap rule) {
            List<Object> key = ComputationStrategy.createDependencyAssignmentTuple(this.dependencies(), rule);
            Preconditions.checkState(this.lookupTable.containsKey(key), "Error in rule '%s': precomputed value missing for dependencies: %s. Available keys: %s.", (Object)rule.getLabel(), (Object)Iterables.toString(key), (Object)Iterables.toString(this.lookupTable.keySet()));
            return this.lookupTable.get(key);
        }

        @Override
        <T> List<T> getPossibleValues(Type<T> type, Rule rule) {
            ArrayList<T> result = new ArrayList<T>(this.lookupTable.size());
            for (Object obj : this.lookupTable.values()) {
                result.add(type.cast(obj));
            }
            return result;
        }
    }

    public static final class StarlarkComputedDefaultTemplate {
        private final Type<?> type;
        private final StarlarkCallbackHelper callback;
        private final ImmutableList<String> dependencies;

        public StarlarkComputedDefaultTemplate(Type<?> type, ImmutableList<String> dependencies, StarlarkCallbackHelper callback) {
            this.type = Preconditions.checkNotNull(type);
            this.dependencies = Ordering.natural().immutableSortedCopy(Preconditions.checkNotNull(dependencies));
            this.callback = Preconditions.checkNotNull(callback);
        }

        StarlarkComputedDefault computePossibleValues(Attribute attr, Rule rule, final EventHandler eventHandler) throws InterruptedException, CannotPrecomputeDefaultsException {
            HashMap<List<Object>, Object> lookupTable;
            final StarlarkComputedDefaultTemplate owner = this;
            String msg = String.format("Cannot compute default value of attribute '%s' in rule '%s': ", attr.getPublicName(), rule.getLabel());
            final AtomicReference caughtEvalExceptionIfAny = new AtomicReference();
            ComputationStrategy<InterruptedException> strategy = new ComputationStrategy<InterruptedException>(){

                @Override
                @Nullable
                public Object compute(AttributeMap map) throws InterruptedException {
                    try {
                        return owner.computeValue(eventHandler, map);
                    }
                    catch (EvalException ex) {
                        caughtEvalExceptionIfAny.compareAndSet(null, ex);
                        return null;
                    }
                }
            };
            ImmutableList.Builder dependencyTypesBuilder = ImmutableList.builder();
            try {
                for (String dependency : this.dependencies) {
                    Attribute attribute = rule.getRuleClassObject().getAttributeByNameMaybe(dependency);
                    if (attribute == null) {
                        throw new AttributeNotFoundException(String.format("No such attribute %s in rule %s", dependency, rule.getLabel()));
                    }
                    dependencyTypesBuilder.add(attribute.getType());
                }
                lookupTable = new HashMap<List<Object>, Object>(strategy.computeValuesForAllCombinations(this.dependencies, attr.getType(), rule, FixedComputationLimiter.INSTANCE));
                if (caughtEvalExceptionIfAny.get() != null) {
                    throw (EvalException)caughtEvalExceptionIfAny.get();
                }
            }
            catch (AttributeNotFoundException | TooManyConfigurableAttributesException | EvalException ex) {
                String error = msg + ex.getMessage();
                rule.reportError(error, eventHandler);
                throw new CannotPrecomputeDefaultsException(error);
            }
            return new StarlarkComputedDefault(this.dependencies, (ImmutableList<Type<?>>)dependencyTypesBuilder.build(), (Map<List<Object>, Object>)lookupTable);
        }

        private Object computeValue(EventHandler eventHandler, AttributeMap rule) throws EvalException, InterruptedException {
            HashMap<String, Object> attrValues = new HashMap<String, Object>();
            for (String attrName : rule.getAttributeNames()) {
                Object value;
                Attribute attr = rule.getAttributeDefinition(attrName);
                if (attr.hasComputedDefault() || Starlark.isNullOrNone(value = rule.get(attrName, attr.getType()))) continue;
                attrValues.put(attr.getName(), Starlark.fromJava(value, null));
            }
            return this.invokeCallback(eventHandler, attrValues);
        }

        private Object invokeCallback(EventHandler eventHandler, Map<String, Object> attrValues) throws EvalException, InterruptedException {
            StarlarkInfo attrs = StructProvider.STRUCT.create(attrValues, "No such regular (non computed) attribute '%s'.");
            Object result = this.callback.call(eventHandler, attrs, new Object[0]);
            try {
                return this.type.cast(result == Starlark.NONE ? this.type.getDefaultValue() : result);
            }
            catch (ClassCastException ex) {
                throw Starlark.errorf("expected '%s', but got '%s'", this.type, Starlark.type(result));
            }
        }

        static class CannotPrecomputeDefaultsException
        extends Exception {
            private CannotPrecomputeDefaultsException(String message) {
                super(message);
            }
        }

        private static class AttributeNotFoundException
        extends Exception {
            private AttributeNotFoundException(String message) {
                super(message);
            }
        }
    }

    public static abstract class ComputedDefault
    implements StarlarkValue {
        private final ImmutableList<String> dependencies;

        protected ComputedDefault() {
            this(ImmutableList.of());
        }

        protected ComputedDefault(String depAttribute) {
            this(ImmutableList.of(depAttribute));
        }

        protected ComputedDefault(String depAttribute1, String depAttribute2) {
            this(ImmutableList.of(depAttribute1, depAttribute2));
        }

        ComputedDefault(ImmutableList<String> dependencies) {
            this.dependencies = Ordering.natural().immutableSortedCopy(dependencies);
        }

        <T> List<T> getPossibleValues(Type<T> type, Rule rule) {
            final ComputedDefault owner = this;
            if (this.dependencies.isEmpty()) {
                AggregatingAttributeMapper mapper = AggregatingAttributeMapper.of(rule);
                Object value = owner.getDefault(mapper.createMapBackedAttributeMap(ImmutableMap.of()));
                return Lists.newArrayList(type.cast(value));
            }
            ComputationStrategy<RuntimeException> strategy = new ComputationStrategy<RuntimeException>(){

                @Override
                public Object compute(AttributeMap map) {
                    return owner.getDefault(map);
                }
            };
            return new ArrayList<T>(strategy.computeValuesForAllCombinations(this.dependencies, type, rule, NULL_COMPUTATION_LIMITER).values());
        }

        public ImmutableList<String> dependencies() {
            return this.dependencies;
        }

        public boolean resolvableWithRawAttributes() {
            return false;
        }

        @Nullable
        public abstract Object getDefault(AttributeMap var1);
    }

    private static abstract class ComputationStrategy<TComputeException extends Exception> {
        private ComputationStrategy() {
        }

        abstract Object compute(AttributeMap var1) throws TComputeException;

        <T, TLimitException extends Exception> Map<List<Object>, T> computeValuesForAllCombinations(List<String> dependencies, Type<T> type, Rule rule, ComputationLimiter<TLimitException> limiter) throws TComputeException, TLimitException {
            AggregatingAttributeMapper mapper = AggregatingAttributeMapper.of(rule);
            List<Map<String, Object>> depMaps = mapper.visitAttributes(dependencies, limiter);
            HashMap<List<Object>, T> valueMap = Maps.newHashMapWithExpectedSize(depMaps.size());
            for (Map<String, Object> depMap : depMaps) {
                AttributeMap attrMap = mapper.createMapBackedAttributeMap(depMap);
                Object value = this.compute(attrMap);
                List<Object> key = ComputationStrategy.createDependencyAssignmentTuple(dependencies, attrMap);
                valueMap.put(key, type.cast(value));
            }
            return valueMap;
        }

        static List<Object> createDependencyAssignmentTuple(List<String> dependencies, AttributeMap attrMap) {
            ArrayList<Object> tuple = new ArrayList<Object>(dependencies.size());
            for (String attrName : dependencies) {
                Type<?> attrType = attrMap.getAttributeType(attrName);
                tuple.add(attrMap.get(attrName, attrType));
            }
            return tuple;
        }
    }

    private static class FixedComputationLimiter
    implements ComputationLimiter<TooManyConfigurableAttributesException> {
        private static final int COMPUTED_DEFAULT_MAX_COMBINATIONS = 64;
        private static final FixedComputationLimiter INSTANCE = new FixedComputationLimiter();

        private FixedComputationLimiter() {
        }

        @Override
        public void onComputationCount(int count) throws TooManyConfigurableAttributesException {
            if (count > 64) {
                throw new TooManyConfigurableAttributesException(64);
            }
        }
    }

    private static class TooManyConfigurableAttributesException
    extends Exception {
        TooManyConfigurableAttributesException(int max) {
            super(String.format("Too many configurable attributes to compute all possible values: Found more than %d possible values.", max));
        }
    }

    static interface ComputationLimiter<TException extends Exception> {
        public void onComputationCount(int var1) throws TException;
    }

    public static class Builder<TYPE> {
        private final String name;
        private final Type<TYPE> type;
        private TransitionFactory<AttributeTransitionData> transitionFactory = NoTransition.createFactory();
        private RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabels = ANY_RULE;
        private RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabelsWarning = NO_RULE;
        private FileTypeSet allowedFileTypesForLabels;
        private ValidityPredicate validityPredicate = ANY_EDGE;
        private Object value;
        private String doc;
        private AttributeValueSource valueSource = AttributeValueSource.DIRECT;
        private boolean valueSet;
        private Set<PropertyFlag> propertyFlags = EnumSet.noneOf(PropertyFlag.class);
        private PredicateWithMessage<Object> allowedValues = null;
        private RequiredProviders.Builder requiredProvidersBuilder = RequiredProviders.acceptAnyBuilder();
        private AspectsListBuilder aspectsListBuilder = new AspectsListBuilder();

        public Builder(String name, Type<TYPE> type) {
            this.name = Preconditions.checkNotNull(name);
            this.type = Preconditions.checkNotNull(type);
            if (Attribute.isImplicit(name) || Attribute.isLateBound(name)) {
                this.setPropertyFlag(PropertyFlag.UNDOCUMENTED, "undocumented");
            }
        }

        @CanIgnoreReturnValue
        private Builder<TYPE> setPropertyFlag(PropertyFlag flag, String propertyName) {
            Preconditions.checkState(!this.propertyFlags.contains((Object)flag), "'%s' flag is already set", (Object)propertyName);
            this.propertyFlags.add(flag);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> setPropertyFlag(String propertyName) throws EvalException {
            PropertyFlag flag;
            try {
                flag = PropertyFlag.valueOf(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw Starlark.errorf("unknown attribute flag '%s'", propertyName);
            }
            try {
                this.setPropertyFlag(flag, propertyName);
            }
            catch (IllegalStateException e) {
                throw new EvalException(e);
            }
            return this;
        }

        public Builder<TYPE> mandatory() {
            return this.setPropertyFlag(PropertyFlag.MANDATORY, "mandatory");
        }

        public Builder<TYPE> nonEmpty() {
            Preconditions.checkNotNull(this.type.getListElementType(), "attribute '%s' must be a list", (Object)this.name);
            return this.setPropertyFlag(PropertyFlag.NON_EMPTY, "non_empty");
        }

        public Builder<TYPE> singleArtifact() {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "attribute '%s' must be a label-valued type", (Object)this.name);
            return this.setPropertyFlag(PropertyFlag.SINGLE_ARTIFACT, "single_artifact");
        }

        public Builder<TYPE> silentRuleClassFilter() {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            return this.setPropertyFlag(PropertyFlag.SILENT_RULECLASS_FILTER, "silent_ruleclass_filter");
        }

        public Builder<TYPE> skipAnalysisTimeFileTypeCheck() {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            return this.setPropertyFlag(PropertyFlag.SKIP_ANALYSIS_TIME_FILETYPE_CHECK, "skip_analysis_time_filetype_check");
        }

        public Builder<TYPE> orderIndependent() {
            Preconditions.checkNotNull(this.type.getListElementType(), "attribute '%s' must be a list", (Object)this.name);
            return this.setPropertyFlag(PropertyFlag.ORDER_INDEPENDENT, "order-independent");
        }

        public Builder<TYPE> useOutputLicenses() {
            Preconditions.checkState(BuildType.isLabelType(this.type), "must be a label type");
            return this.setPropertyFlag(PropertyFlag.OUTPUT_LICENSES, "output_license");
        }

        public Builder<TYPE> hasStarlarkDefinedTransition() {
            return this.setPropertyFlag(PropertyFlag.HAS_STARLARK_DEFINED_TRANSITION, "starlark-defined split transition");
        }

        public Builder<TYPE> hasAnalysisTestTransition() {
            return this.setPropertyFlag(PropertyFlag.HAS_ANALYSIS_TEST_TRANSITION, "analysis-test split transition");
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> cfg(TransitionFactory<AttributeTransitionData> transitionFactory) {
            Preconditions.checkNotNull(transitionFactory);
            Preconditions.checkState(NoTransition.isInstance(this.transitionFactory), "the configuration transition is already set");
            this.transitionFactory = transitionFactory;
            return this;
        }

        public Builder<TYPE> exec() {
            return this.setPropertyFlag(PropertyFlag.EXECUTABLE, "executable");
        }

        public Builder<TYPE> direct_compile_time_input() {
            return this.setPropertyFlag(PropertyFlag.DIRECT_COMPILE_TIME_INPUT, "direct_compile_time_input");
        }

        public Builder<TYPE> undocumented(String reason) {
            return this.setPropertyFlag(PropertyFlag.UNDOCUMENTED, "undocumented");
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> setDoc(String doc) {
            this.doc = doc;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> value(TYPE defaultValue) {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = defaultValue;
            this.valueSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> value(ComputedDefault defaultValue) {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = defaultValue;
            this.valueSource = AttributeValueSource.COMPUTED_DEFAULT;
            this.valueSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> value(NativeComputedDefaultApi defaultValue) {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = defaultValue;
            this.valueSource = AttributeValueSource.NATIVE_COMPUTED_DEFAULT;
            this.valueSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> value(StarlarkComputedDefaultTemplate starlarkComputedDefaultTemplate) {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = starlarkComputedDefaultTemplate;
            this.valueSource = AttributeValueSource.COMPUTED_DEFAULT;
            this.valueSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> value(LateBoundDefault<?, ? extends TYPE> defaultValue) {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = defaultValue;
            this.valueSource = AttributeValueSource.LATE_BOUND;
            this.valueSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> defaultValue(Object defaultValue, LabelConverter labelConverter, @Nullable String parameterName) throws Type.ConversionException {
            Preconditions.checkState(!this.valueSet, "the default value is already set");
            this.value = this.type.convert(defaultValue, (parameterName == null ? "" : String.format("parameter '%s' of ", parameterName)) + String.format("attribute '%s'", this.name), labelConverter);
            this.valueSet = true;
            return this;
        }

        public Builder<TYPE> defaultValue(Object defaultValue) throws Type.ConversionException {
            return this.defaultValue(defaultValue, null, null);
        }

        public AttributeValueSource getValueSource() {
            return this.valueSource;
        }

        public Builder<TYPE> taggable() {
            return this.setPropertyFlag(PropertyFlag.TAGGABLE, "taggable");
        }

        public Builder<TYPE> skipPrereqValidatorCheck() {
            return this.setPropertyFlag(PropertyFlag.SKIP_PREREQ_VALIDATOR_CHECKS, "skip_prereq_validator_checks");
        }

        public Builder<TYPE> checkConstraints() {
            Verify.verify(!this.propertyFlags.contains((Object)PropertyFlag.SKIP_CONSTRAINTS_OVERRIDE), "constraint checking is already overridden to be skipped", new Object[0]);
            return this.setPropertyFlag(PropertyFlag.CHECK_CONSTRAINTS_OVERRIDE, "check_constraints");
        }

        public Builder<TYPE> dontCheckConstraints() {
            Verify.verify(!this.propertyFlags.contains((Object)PropertyFlag.CHECK_CONSTRAINTS_OVERRIDE), "constraint checking is already overridden to be checked", new Object[0]);
            return this.setPropertyFlag(PropertyFlag.SKIP_CONSTRAINTS_OVERRIDE, "dont_check_constraints");
        }

        public Builder<TYPE> allowedRuleClasses(Iterable<String> allowedRuleClasses) {
            return this.allowedRuleClasses(RuleClass.Builder.RuleClassNamePredicate.only(allowedRuleClasses));
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> allowedRuleClasses(RuleClass.Builder.RuleClassNamePredicate allowedRuleClasses) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            this.propertyFlags.add(PropertyFlag.STRICT_LABEL_CHECKING);
            this.allowedRuleClassesForLabels = allowedRuleClasses;
            return this;
        }

        public Builder<TYPE> allowedRuleClasses(String ... allowedRuleClasses) {
            return this.allowedRuleClasses(ImmutableSet.copyOf(allowedRuleClasses));
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> allowedFileTypes(FileTypeSet allowedFileTypes) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY || this.type.getLabelClass() == Type.LabelClass.GENQUERY_SCOPE_REFERENCE, "must be a label-valued type");
            this.propertyFlags.add(PropertyFlag.STRICT_LABEL_CHECKING);
            this.allowedFileTypesForLabels = Preconditions.checkNotNull(allowedFileTypes);
            return this;
        }

        public Builder<TYPE> allowedFileTypes(FileType ... allowedFileTypes) {
            return this.allowedFileTypes(FileTypeSet.of(allowedFileTypes));
        }

        public Builder<TYPE> legacyAllowAnyFileType() {
            return this.allowedFileTypes(FileTypeSet.ANY_FILE);
        }

        public Builder<TYPE> allowedRuleClassesWithWarning(Collection<String> allowedRuleClasses) {
            return this.allowedRuleClassesWithWarning(RuleClass.Builder.RuleClassNamePredicate.only(allowedRuleClasses));
        }

        @CanIgnoreReturnValue
        Builder<TYPE> allowedRuleClassesWithWarning(RuleClass.Builder.RuleClassNamePredicate allowedRuleClasses) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            this.propertyFlags.add(PropertyFlag.STRICT_LABEL_CHECKING);
            this.allowedRuleClassesForLabelsWarning = allowedRuleClasses;
            return this;
        }

        public Builder<TYPE> allowedRuleClassesWithWarning(String ... allowedRuleClasses) {
            return this.allowedRuleClassesWithWarning(ImmutableSet.copyOf(allowedRuleClasses));
        }

        @CanIgnoreReturnValue
        final Builder<TYPE> mandatoryBuiltinProvidersList(Iterable<? extends Iterable<Class<? extends TransitiveInfoProvider>>> providersList) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            for (Iterable<Class<? extends TransitiveInfoProvider>> iterable : providersList) {
                this.requiredProvidersBuilder.addBuiltinSet(ImmutableSet.copyOf(iterable));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> mandatoryBuiltinProviders(Iterable<Class<? extends TransitiveInfoProvider>> providers) {
            if (providers.iterator().hasNext()) {
                this.mandatoryBuiltinProvidersList(ImmutableList.of(providers));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> mandatoryProvidersList(Iterable<? extends Iterable<StarlarkProviderIdentifier>> providersList) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            for (Iterable<StarlarkProviderIdentifier> iterable : providersList) {
                this.requiredProvidersBuilder.addStarlarkSet(ImmutableSet.copyOf(iterable));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> mandatoryProviders(Iterable<StarlarkProviderIdentifier> providers) {
            if (providers.iterator().hasNext()) {
                this.mandatoryProvidersList(ImmutableList.of(providers));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> mandatoryProviders(StarlarkProviderIdentifier ... providers) {
            this.mandatoryProviders(Arrays.asList(providers));
            return this;
        }

        public AspectsListBuilder getAspectsListBuilder() {
            return this.aspectsListBuilder;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> aspect(NativeAspectClass aspect, Function<Rule, AspectParameters> evaluator) {
            this.aspectsListBuilder.addAspect(aspect, evaluator);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> aspect(NativeAspectClass aspect) {
            this.aspectsListBuilder.addAspect(aspect);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> aspect(Aspect aspect) {
            this.aspectsListBuilder.addAspect(aspect);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> validityPredicate(ValidityPredicate validityPredicate) {
            this.propertyFlags.add(PropertyFlag.STRICT_LABEL_CHECKING);
            this.validityPredicate = validityPredicate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> allowedValues(PredicateWithMessage<Object> allowedValues) {
            this.allowedValues = allowedValues;
            this.propertyFlags.add(PropertyFlag.CHECK_ALLOWED_VALUES);
            return this;
        }

        public Builder<TYPE> nonconfigurable(String reason) {
            Preconditions.checkState(!reason.isEmpty());
            return this.setPropertyFlag(PropertyFlag.NONCONFIGURABLE, "nonconfigurable");
        }

        public Builder<TYPE> tool(String reason) {
            Preconditions.checkState(this.type.getLabelClass() == Type.LabelClass.DEPENDENCY, "must be a label-valued type");
            Preconditions.checkState(!reason.isEmpty());
            return this.setPropertyFlag(PropertyFlag.IS_TOOL_DEPENDENCY, "is_tool_dependency");
        }

        @CanIgnoreReturnValue
        public Builder<TYPE> starlarkDefined() {
            return this.setPropertyFlag(PropertyFlag.STARLARK_DEFINED, "starlark_defined");
        }

        public ImmutableAttributeFactory buildPartial() {
            Preconditions.checkState(!this.allowedRuleClassesForLabels.consideredOverlapping(this.allowedRuleClassesForLabelsWarning), "allowedRuleClasses %s and allowedRuleClassesWithWarning %s may not contain the same rule classes", (Object)this.allowedRuleClassesForLabels, (Object)this.allowedRuleClassesForLabelsWarning);
            return new ImmutableAttributeFactory(this.type, this.doc, Sets.immutableEnumSet(this.propertyFlags), this.valueSet ? this.value : this.type.getDefaultValue(), this.transitionFactory, this.allowedRuleClassesForLabels, this.allowedRuleClassesForLabelsWarning, this.allowedFileTypesForLabels, this.validityPredicate, this.valueSource, this.valueSet, this.allowedValues, this.requiredProvidersBuilder.build(), this.aspectsListBuilder.getAspectsDetails());
        }

        public Attribute build() {
            return this.build(this.name);
        }

        public Attribute build(String name) {
            return this.buildPartial().build(name);
        }
    }

    public static class ImmutableAttributeFactory {
        private final Type<?> type;
        private final String doc;
        private final TransitionFactory<AttributeTransitionData> transitionFactory;
        private final RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabels;
        private final RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabelsWarning;
        private final FileTypeSet allowedFileTypesForLabels;
        private final ValidityPredicate validityPredicate;
        private final Object value;
        private final AttributeValueSource valueSource;
        private final boolean valueSet;
        private final ImmutableSet<PropertyFlag> propertyFlags;
        private final PredicateWithMessage<Object> allowedValues;
        private final RequiredProviders requiredProviders;
        private final ImmutableList<AspectsListBuilder.AspectDetails<?>> aspects;

        private ImmutableAttributeFactory(Type<?> type, String doc, ImmutableSet<PropertyFlag> propertyFlags, Object value, TransitionFactory<AttributeTransitionData> transitionFactory, RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabels, RuleClass.Builder.RuleClassNamePredicate allowedRuleClassesForLabelsWarning, FileTypeSet allowedFileTypesForLabels, ValidityPredicate validityPredicate, AttributeValueSource valueSource, boolean valueSet, PredicateWithMessage<Object> allowedValues, RequiredProviders requiredProviders, ImmutableList<AspectsListBuilder.AspectDetails<?>> aspects) {
            this.type = type;
            this.doc = doc;
            this.transitionFactory = transitionFactory;
            this.allowedRuleClassesForLabels = allowedRuleClassesForLabels;
            this.allowedRuleClassesForLabelsWarning = allowedRuleClassesForLabelsWarning;
            this.allowedFileTypesForLabels = allowedFileTypesForLabels;
            this.validityPredicate = validityPredicate;
            this.value = value;
            this.valueSource = valueSource;
            this.valueSet = valueSet;
            this.propertyFlags = propertyFlags;
            this.allowedValues = allowedValues;
            this.requiredProviders = requiredProviders;
            this.aspects = aspects;
        }

        public AttributeValueSource getValueSource() {
            return this.valueSource;
        }

        public boolean isValueSet() {
            return this.valueSet;
        }

        public Attribute build(String name) {
            Preconditions.checkState(!name.isEmpty(), "name has not been set");
            if (this.valueSource == AttributeValueSource.LATE_BOUND) {
                Preconditions.checkState(Attribute.isLateBound(name));
                Preconditions.checkState(!this.transitionFactory.isSplit());
            }
            FileTypeSet allowedFileTypesForLabels = this.allowedFileTypesForLabels;
            if (this.type.getLabelClass() == Type.LabelClass.DEPENDENCY) {
                if (Attribute.isPrivateAttribute(name) && allowedFileTypesForLabels == null) {
                    allowedFileTypesForLabels = FileTypeSet.ANY_FILE;
                }
                Preconditions.checkNotNull(allowedFileTypesForLabels, "allowedFileTypesForLabels not set for %s", (Object)name);
            } else if (this.type.getLabelClass() == Type.LabelClass.OUTPUT && allowedFileTypesForLabels == null) {
                allowedFileTypesForLabels = FileTypeSet.ANY_FILE;
            }
            return new Attribute(name, this.doc, this.type, this.propertyFlags, this.value, this.transitionFactory, this.allowedRuleClassesForLabels, this.allowedRuleClassesForLabelsWarning, allowedFileTypesForLabels, this.validityPredicate, this.allowedValues, this.requiredProviders, this.aspects);
        }
    }

    public static class AllowedValueSet
    implements PredicateWithMessage<Object> {
        private final ImmutableSet<Object> allowedValues;

        public AllowedValueSet(Object ... values) {
            this(Arrays.asList(values));
        }

        public AllowedValueSet(Iterable<?> values) {
            Preconditions.checkNotNull(values);
            Preconditions.checkArgument(!Iterables.isEmpty(values));
            for (Object v : values) {
                Starlark.checkValid(v);
            }
            this.allowedValues = ImmutableSet.copyOf(values);
        }

        @Override
        public boolean apply(Object input) {
            return this.allowedValues.contains(input);
        }

        @Override
        public String getErrorReason(Object value) {
            return String.format("has to be one of %s instead of '%s'", StringUtil.joinEnglishList(this.allowedValues, "or", "'"), value);
        }

        @VisibleForTesting
        public Collection<Object> getAllowedValues() {
            return this.allowedValues;
        }
    }

    public static interface ValidityPredicate {
        @Nullable
        public String checkValid(Rule var1, String var2, Set<String> var3);
    }

    private static enum PropertyFlag {
        MANDATORY,
        EXECUTABLE,
        UNDOCUMENTED,
        TAGGABLE,
        ORDER_INDEPENDENT,
        STRICT_LABEL_CHECKING,
        DIRECT_COMPILE_TIME_INPUT,
        NON_EMPTY,
        SINGLE_ARTIFACT,
        SILENT_RULECLASS_FILTER,
        SKIP_ANALYSIS_TIME_FILETYPE_CHECK,
        CHECK_ALLOWED_VALUES,
        NONCONFIGURABLE,
        SKIP_PREREQ_VALIDATOR_CHECKS,
        CHECK_CONSTRAINTS_OVERRIDE,
        SKIP_CONSTRAINTS_OVERRIDE,
        OUTPUT_LICENSES,
        HAS_STARLARK_DEFINED_TRANSITION,
        HAS_ANALYSIS_TEST_TRANSITION,
        IS_TOOL_DEPENDENCY,
        STARLARK_DEFINED;

    }
}

