/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.packages.Aspect;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.NativeAspectClass;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.StarlarkAspectClass;
import com.google.devtools.build.lib.packages.StarlarkDefinedAspect;
import com.google.devtools.build.lib.packages.StarlarkNativeAspect;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public final class AspectsListBuilder {
    private final HashMap<String, AspectDetails<?>> aspects = new LinkedHashMap();
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Function<Rule, AspectParameters> EMPTY_FUNCTION = input -> AspectParameters.EMPTY;

    public AspectsListBuilder() {
    }

    public AspectsListBuilder(ImmutableList<AspectDetails<?>> aspectsList) {
        for (AspectDetails aspectDetails : aspectsList) {
            this.aspects.put(aspectDetails.getName(), aspectDetails);
        }
    }

    public ImmutableList<AspectDetails<?>> getAspectsDetails() {
        return ImmutableList.copyOf(this.aspects.values());
    }

    public ImmutableList<Aspect> buildAspects(ImmutableMap<String, String> aspectsParameters) throws EvalException {
        Preconditions.checkArgument(aspectsParameters != null, "aspectsParameters cannot be null");
        ImmutableList.Builder aspectsList = ImmutableList.builder();
        for (AspectDetails<?> aspect : this.aspects.values()) {
            aspectsList.add(aspect.getTopLevelAspect(aspectsParameters));
        }
        return aspectsList.build();
    }

    public boolean validateTopLevelAspectsParameters(ImmutableMap<String, String> aspectsParameters) throws EvalException {
        Preconditions.checkArgument(aspectsParameters != null, "aspectsParameters cannot be null");
        ImmutableSet.Builder usedParametersBuilder = ImmutableSet.builder();
        for (AspectDetails<?> aspectDetails : this.aspects.values()) {
            if (!(aspectDetails instanceof StarlarkAspectDetails)) continue;
            ImmutableList<Attribute> aspectAttributes = ((StarlarkAspectDetails)aspectDetails).aspect.getAttributes();
            for (Attribute attr : aspectAttributes) {
                if (attr.isImplicit() || attr.isLateBound()) continue;
                String attrName = attr.getName();
                if (aspectsParameters.containsKey(attrName)) {
                    usedParametersBuilder.add(attrName);
                    continue;
                }
                if (!attr.isMandatory()) continue;
                throw Starlark.errorf("Missing mandatory attribute '%s' for aspect '%s'.", attrName, aspectDetails.getName());
            }
        }
        ImmutableCollection usedParameters = usedParametersBuilder.build();
        ImmutableList unusedParameters = aspectsParameters.keySet().stream().filter(arg_0 -> AspectsListBuilder.lambda$validateTopLevelAspectsParameters$0((ImmutableSet)usedParameters, arg_0)).collect(ImmutableList.toImmutableList());
        if (!unusedParameters.isEmpty()) {
            throw Starlark.errorf("Parameters '%s' are not parameters of any of the top-level aspects but they are specified in --aspects_parameters.", unusedParameters);
        }
        return true;
    }

    public void addAspect(NativeAspectClass aspect, Function<Rule, AspectParameters> evaluator) {
        NativeAspectDetails nativeAspectDetails = new NativeAspectDetails(aspect, evaluator);
        AspectDetails oldAspect = this.aspects.put(nativeAspectDetails.getName(), nativeAspectDetails);
        if (oldAspect != null) {
            throw new AssertionError((Object)String.format("Aspect %s has already been added", oldAspect.getName()));
        }
    }

    public void addAspect(NativeAspectClass aspect) {
        this.addAspect(aspect, EMPTY_FUNCTION);
    }

    public void addAspect(StarlarkDefinedAspect starlarkAspect, @Nullable String baseAspectName) throws EvalException {
        boolean needsToAdd = this.needsToBeAdded(starlarkAspect.getName(), baseAspectName);
        if (needsToAdd) {
            StarlarkAspectDetails starlarkAspectDetails = new StarlarkAspectDetails(starlarkAspect, baseAspectName);
            this.aspects.put(starlarkAspect.getName(), starlarkAspectDetails);
        }
    }

    public void addAspect(StarlarkNativeAspect nativeAspect, @Nullable String baseAspectName) throws EvalException {
        boolean needsToAdd = this.needsToBeAdded(nativeAspect.getName(), baseAspectName);
        if (needsToAdd) {
            NativeAspectDetails nativeAspectDetails = new NativeAspectDetails(nativeAspect, nativeAspect.getDefaultParametersExtractor(), baseAspectName);
            this.aspects.put(nativeAspect.getName(), nativeAspectDetails);
        }
    }

    public void addAspect(Aspect aspect) {
        PredefinedAspectDetails predefinedAspectDetails = new PredefinedAspectDetails(aspect);
        AspectDetails oldAspect = this.aspects.put(predefinedAspectDetails.getName(), predefinedAspectDetails);
        if (oldAspect != null) {
            throw new AssertionError((Object)String.format("Aspect %s has already been added", oldAspect.getName()));
        }
    }

    private boolean needsToBeAdded(String aspectName, @Nullable String baseAspectName) throws EvalException {
        AspectDetails<?> oldAspect = this.aspects.get(aspectName);
        if (oldAspect != null) {
            if (baseAspectName != null) {
                return false;
            }
            String oldAspectBaseAspectName = oldAspect.baseAspectName;
            if (oldAspectBaseAspectName != null) {
                throw Starlark.errorf("aspect %s was added before as a required aspect of aspect %s", oldAspect.getName(), oldAspectBaseAspectName);
            }
            throw Starlark.errorf("aspect %s added more than once", oldAspect.getName());
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$validateTopLevelAspectsParameters$0(ImmutableSet usedParameters, String p) {
        return !usedParameters.contains(p);
    }

    private static class PredefinedAspectDetails
    extends AspectDetails<AspectClass> {
        private final Aspect aspect;

        PredefinedAspectDetails(Aspect aspect) {
            super(aspect.getAspectClass(), null);
            this.aspect = aspect;
        }

        @Override
        public Aspect getAspect(Rule rule) {
            return this.aspect;
        }

        @Override
        public Aspect getTopLevelAspect(ImmutableMap<String, String> aspectParameters) throws EvalException {
            return this.aspect;
        }
    }

    private static class StarlarkAspectDetails
    extends AspectDetails<StarlarkAspectClass> {
        private final StarlarkDefinedAspect aspect;

        private StarlarkAspectDetails(StarlarkDefinedAspect aspect, String baseAspectName) {
            super(aspect.getAspectClass(), aspect.getDefaultParametersExtractor(), baseAspectName);
            this.aspect = aspect;
        }

        @Override
        public ImmutableSet<String> getRequiredParameters() {
            return this.aspect.getParamAttributes();
        }

        @Override
        public ImmutableList<Attribute> getAspectAttributes() {
            return this.aspect.getAttributes();
        }

        @Override
        public Aspect getAspect(Rule rule) {
            AspectParameters params = (AspectParameters)this.parametersExtractor.apply(rule);
            return Aspect.forStarlark((StarlarkAspectClass)this.aspectClass, this.aspect.getDefinition(params), params);
        }

        @Override
        public Aspect getTopLevelAspect(ImmutableMap<String, String> aspectParameters) throws EvalException {
            AspectParameters params = this.aspect.extractTopLevelParameters(aspectParameters);
            return Aspect.forStarlark((StarlarkAspectClass)this.aspectClass, this.aspect.getDefinition(params), params);
        }
    }

    private static class NativeAspectDetails
    extends AspectDetails<NativeAspectClass> {
        NativeAspectDetails(NativeAspectClass aspectClass, Function<Rule, AspectParameters> parametersExtractor) {
            super(aspectClass, parametersExtractor);
        }

        NativeAspectDetails(NativeAspectClass aspectClass, Function<Rule, AspectParameters> parametersExtractor, String baseAspectName) {
            super(aspectClass, parametersExtractor, baseAspectName);
        }

        @Override
        @Nullable
        public Aspect getAspect(Rule rule) {
            AspectParameters params = (AspectParameters)this.parametersExtractor.apply(rule);
            return params == null ? null : Aspect.forNative((NativeAspectClass)this.aspectClass, params);
        }

        @Override
        protected Aspect getTopLevelAspect(ImmutableMap<String, String> aspectParameters) throws EvalException {
            return Aspect.forNative((NativeAspectClass)this.aspectClass, AspectParameters.EMPTY);
        }
    }

    public static abstract class AspectDetails<C extends AspectClass> {
        final C aspectClass;
        final Function<Rule, AspectParameters> parametersExtractor;
        final String baseAspectName;

        private AspectDetails(C aspectClass, Function<Rule, AspectParameters> parametersExtractor) {
            this.aspectClass = aspectClass;
            this.parametersExtractor = parametersExtractor;
            this.baseAspectName = null;
        }

        private AspectDetails(C aspectClass, Function<Rule, AspectParameters> parametersExtractor, String baseAspectName) {
            this.aspectClass = aspectClass;
            this.parametersExtractor = parametersExtractor;
            this.baseAspectName = baseAspectName;
        }

        public String getName() {
            return this.aspectClass.getName();
        }

        public ImmutableSet<String> getRequiredParameters() {
            return ImmutableSet.of();
        }

        public ImmutableList<Attribute> getAspectAttributes() {
            return ImmutableList.of();
        }

        protected abstract Aspect getAspect(Rule var1);

        protected abstract Aspect getTopLevelAspect(ImmutableMap<String, String> var1) throws EvalException;

        C getAspectClass() {
            return this.aspectClass;
        }
    }
}

