/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;

public final class AspectParameters {
    private final ImmutableMultimap<String, String> attributes;
    public static final AspectParameters EMPTY = new AspectParameters(ImmutableMultimap.of());

    private AspectParameters(Multimap<String, String> attributes) {
        this.attributes = ImmutableMultimap.copyOf(attributes);
    }

    private static AspectParameters create(ImmutableMultimap<String, String> attributes) {
        if (attributes.isEmpty()) {
            return EMPTY;
        }
        return new AspectParameters(attributes);
    }

    public ImmutableCollection<String> getAttribute(String key) {
        return this.attributes.get((Object)key);
    }

    public ImmutableMultimap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getOnlyValueOfAttribute(String key) {
        return Iterables.getOnlyElement(this.getAttribute(key));
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectParameters)) {
            return false;
        }
        AspectParameters that = (AspectParameters)other;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode(this.attributes);
    }

    public String toString() {
        return this.attributes.toString();
    }

    public static class Builder {
        private final ImmutableMultimap.Builder<String, String> attributes = ImmutableMultimap.builder();

        @CanIgnoreReturnValue
        public Builder addAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public AspectParameters build() {
            return AspectParameters.create(this.attributes.build());
        }
    }
}

