/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableMultimap;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.protobuf.TextFormat;
import java.util.Map;
import java.util.Objects;

public final class AspectDescriptor {
    private final AspectClass aspectClass;
    private final AspectParameters aspectParameters;

    public AspectDescriptor(AspectClass aspectClass, AspectParameters aspectParameters) {
        this.aspectClass = aspectClass;
        this.aspectParameters = aspectParameters;
    }

    public AspectDescriptor(AspectClass aspectClass) {
        this(aspectClass, AspectParameters.EMPTY);
    }

    public AspectClass getAspectClass() {
        return this.aspectClass;
    }

    public AspectParameters getParameters() {
        return this.aspectParameters;
    }

    public int hashCode() {
        return 31 * this.aspectClass.hashCode() + this.aspectParameters.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AspectDescriptor)) {
            return false;
        }
        AspectDescriptor that = (AspectDescriptor)obj;
        return Objects.equals(this.aspectClass, that.aspectClass) && Objects.equals(this.aspectParameters, that.aspectParameters);
    }

    public String toString() {
        return this.getDescription();
    }

    public String getDescription() {
        if (this.aspectParameters.isEmpty()) {
            return this.aspectClass.getName();
        }
        StringBuilder builder = new StringBuilder(this.aspectClass.getName());
        builder.append('[');
        ImmutableMultimap<String, String> attributes = this.aspectParameters.getAttributes();
        boolean first = true;
        for (Map.Entry attribute : attributes.entries()) {
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            builder.append((String)attribute.getKey());
            builder.append("=\"");
            builder.append(TextFormat.escapeDoubleQuotesAndBackslashes((String)attribute.getValue()));
            builder.append("\"");
        }
        builder.append(']');
        return builder.toString();
    }
}

