/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.devtools.build.lib.analysis.TransitiveInfoProvider;
import com.google.devtools.build.lib.analysis.config.Fragment;
import com.google.devtools.build.lib.analysis.config.ToolchainTypeRequirement;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.AdvertisedProviderSet;
import com.google.devtools.build.lib.packages.Aspect;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.ConfigurationFragmentPolicy;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.ExecGroup;
import com.google.devtools.build.lib.packages.RequiredProviders;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.packages.Type;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class AspectDefinition {
    private final AspectClass aspectClass;
    private final AdvertisedProviderSet advertisedProviders;
    private final RequiredProviders requiredProviders;
    private final RequiredProviders requiredProvidersForAspects;
    private final ImmutableMap<String, Attribute> attributes;
    private final ImmutableSet<ToolchainTypeRequirement> toolchainTypes;
    @Nullable
    private final ImmutableSet<String> restrictToAttributes;
    @Nullable
    private final ConfigurationFragmentPolicy configurationFragmentPolicy;
    private final boolean applyToFiles;
    private final boolean applyToGeneratingRules;
    private final ImmutableSet<AspectClass> requiredAspectClasses;
    private final ImmutableSet<Label> execCompatibleWith;
    private final ImmutableMap<String, ExecGroup> execGroups;

    public AdvertisedProviderSet getAdvertisedProviders() {
        return this.advertisedProviders;
    }

    private AspectDefinition(AspectClass aspectClass, AdvertisedProviderSet advertisedProviders, RequiredProviders requiredProviders, RequiredProviders requiredProvidersForAspects, ImmutableMap<String, Attribute> attributes, ImmutableSet<ToolchainTypeRequirement> toolchainTypes, @Nullable ImmutableSet<String> restrictToAttributes, @Nullable ConfigurationFragmentPolicy configurationFragmentPolicy, boolean applyToFiles, boolean applyToGeneratingRules, ImmutableSet<AspectClass> requiredAspectClasses, ImmutableSet<Label> execCompatibleWith, ImmutableMap<String, ExecGroup> execGroups) {
        this.aspectClass = aspectClass;
        this.advertisedProviders = advertisedProviders;
        this.requiredProviders = requiredProviders;
        this.requiredProvidersForAspects = requiredProvidersForAspects;
        this.attributes = attributes;
        this.toolchainTypes = toolchainTypes;
        this.restrictToAttributes = restrictToAttributes;
        this.configurationFragmentPolicy = configurationFragmentPolicy;
        this.applyToFiles = applyToFiles;
        this.applyToGeneratingRules = applyToGeneratingRules;
        this.requiredAspectClasses = requiredAspectClasses;
        this.execCompatibleWith = execCompatibleWith;
        this.execGroups = execGroups;
    }

    public String getName() {
        return this.aspectClass.getName();
    }

    public ImmutableMap<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public ImmutableSet<ToolchainTypeRequirement> getToolchainTypes() {
        return this.toolchainTypes;
    }

    public ImmutableSet<Label> execCompatibleWith() {
        return this.execCompatibleWith;
    }

    public ImmutableMap<String, ExecGroup> execGroups() {
        return this.execGroups;
    }

    public RequiredProviders getRequiredProviders() {
        return this.requiredProviders;
    }

    public RequiredProviders getRequiredProvidersForAspects() {
        return this.requiredProvidersForAspects;
    }

    public boolean propagateAlong(String attributeName) {
        if (this.restrictToAttributes != null) {
            return this.restrictToAttributes.contains(attributeName);
        }
        return true;
    }

    public ConfigurationFragmentPolicy getConfigurationFragmentPolicy() {
        return this.configurationFragmentPolicy;
    }

    public boolean applyToFiles() {
        return this.applyToFiles;
    }

    public boolean applyToGeneratingRules() {
        return this.applyToGeneratingRules;
    }

    public static boolean satisfies(Aspect aspect, AdvertisedProviderSet advertisedProviderSet) {
        return aspect.getDefinition().requiredProviders.isSatisfiedBy(advertisedProviderSet);
    }

    public boolean requires(Aspect maybeRequiredAspect) {
        return this.requiredAspectClasses.contains(maybeRequiredAspect.getAspectClass());
    }

    public static void addAllAttributesOfAspect(Multimap<Attribute, Label> labelBuilder, Aspect aspect, DependencyFilter dependencyFilter) {
        AspectDefinition.forEachLabelDepFromAllAttributesOfAspect(aspect, dependencyFilter, labelBuilder::put);
    }

    public static void forEachLabelDepFromAllAttributesOfAspect(Aspect aspect, DependencyFilter dependencyFilter, BiConsumer<Attribute, Label> consumer) {
        Type.LabelVisitor labelVisitor = (label, aspectAttribute) -> {
            if (label == null) {
                return;
            }
            consumer.accept(aspectAttribute, label);
        };
        for (Attribute aspectAttribute2 : aspect.getDefinition().attributes.values()) {
            Type<?> type;
            if (!dependencyFilter.test(aspect, aspectAttribute2) || (type = aspectAttribute2.getType()).getLabelClass() != Type.LabelClass.DEPENDENCY) continue;
            AspectDefinition.visitSingleAttribute(aspectAttribute2, aspectAttribute2.getType(), labelVisitor);
        }
    }

    private static <T> void visitSingleAttribute(Attribute attribute, Type<T> type, Type.LabelVisitor labelVisitor) {
        type.visitLabels(labelVisitor, type.cast(attribute.getDefaultValue()), attribute);
    }

    public static Builder builder(AspectClass aspectClass) {
        return new Builder(aspectClass);
    }

    public static final class Builder {
        private final AspectClass aspectClass;
        private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        private final AdvertisedProviderSet.Builder advertisedProviders = AdvertisedProviderSet.builder();
        private final RequiredProviders.Builder requiredProviders = RequiredProviders.acceptAnyBuilder();
        private final RequiredProviders.Builder requiredAspectProviders = RequiredProviders.acceptNoneBuilder();
        @Nullable
        private LinkedHashSet<String> propagateAlongAttributes = new LinkedHashSet();
        private final ConfigurationFragmentPolicy.Builder configurationFragmentPolicy = new ConfigurationFragmentPolicy.Builder();
        private boolean applyToFiles = false;
        private boolean applyToGeneratingRules = false;
        private final Set<ToolchainTypeRequirement> toolchainTypes = new HashSet<ToolchainTypeRequirement>();
        private ImmutableSet<AspectClass> requiredAspectClasses = ImmutableSet.of();
        private ImmutableSet<Label> execCompatibleWith = ImmutableSet.of();
        private ImmutableMap<String, ExecGroup> execGroups = ImmutableMap.of();

        public Builder(AspectClass aspectClass) {
            this.aspectClass = aspectClass;
        }

        @CanIgnoreReturnValue
        public Builder requireProviderSets(Iterable<ImmutableSet<Class<? extends TransitiveInfoProvider>>> providerSets) {
            for (ImmutableSet<Class<? extends TransitiveInfoProvider>> providerSet : providerSets) {
                this.requiredProviders.addBuiltinSet(providerSet);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireProviders(Class<? extends TransitiveInfoProvider> ... providers) {
            this.requiredProviders.addBuiltinSet(ImmutableSet.copyOf(providers));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireProviders(RequiredProviders requiredProviders) {
            requiredProviders.addToAspectDefinitionBuilder(this);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireStarlarkProviderSets(Iterable<ImmutableSet<StarlarkProviderIdentifier>> providerSets) {
            for (ImmutableSet<StarlarkProviderIdentifier> providerSet : providerSets) {
                if (providerSet.isEmpty()) continue;
                this.requiredProviders.addStarlarkSet(providerSet);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireStarlarkProviders(StarlarkProviderIdentifier ... starlarkProviders) {
            this.requiredProviders.addStarlarkSet(ImmutableSet.copyOf(starlarkProviders));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requiredAspectClasses(ImmutableSet<AspectClass> requiredAspectClasses) {
            this.requiredAspectClasses = requiredAspectClasses;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireAspectsWithProviders(Iterable<ImmutableSet<StarlarkProviderIdentifier>> providerSets) {
            for (ImmutableSet<StarlarkProviderIdentifier> providerSet : providerSets) {
                if (providerSet.isEmpty()) continue;
                this.requiredAspectProviders.addStarlarkSet(providerSet);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requireAspectsWithBuiltinProviders(Class<? extends TransitiveInfoProvider> ... providers) {
            this.requiredAspectProviders.addBuiltinSet(ImmutableSet.copyOf(providers));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder advertiseProvider(Class<?> ... providers) {
            for (Class<?> provider : providers) {
                this.advertisedProviders.addBuiltin(provider);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder advertiseProvider(ImmutableList<StarlarkProviderIdentifier> providers) {
            for (StarlarkProviderIdentifier provider : providers) {
                this.advertisedProviders.addStarlark(provider);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder propagateAlongAttribute(String attribute) {
            Preconditions.checkNotNull(attribute);
            Preconditions.checkState(this.propagateAlongAttributes != null, "Either propagate along all attributes, or along specific attributes, not both");
            this.propagateAlongAttributes.add(attribute);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder propagateAlongAllAttributes() {
            Preconditions.checkState(this.propagateAlongAttributes != null, "Aspects for all attributes must only be specified once");
            Preconditions.checkState(this.propagateAlongAttributes.isEmpty(), "Specify either aspects for all attributes, or for specific attributes, not both");
            this.propagateAlongAttributes = null;
            return this;
        }

        public <TYPE> Builder add(Attribute.Builder<TYPE> attr) {
            Attribute attribute = attr.build();
            return this.add(attribute);
        }

        @CanIgnoreReturnValue
        public Builder add(Attribute attribute) {
            Preconditions.checkArgument(attribute.isImplicit() || attribute.isLateBound() || attribute.getType() == Type.STRING && attribute.checkAllowedValues() || attribute.getType() == Type.INTEGER && attribute.checkAllowedValues() || attribute.getType() == Type.BOOLEAN, "%s: Invalid attribute '%s' (%s)", (Object)this.aspectClass.getName(), (Object)attribute.getName(), attribute.getType());
            Preconditions.checkArgument(attribute.getType().getLabelClass() != Type.LabelClass.DEPENDENCY || !(attribute.getDefaultValueUnchecked() instanceof Attribute.ComputedDefault), "%s: Invalid attribute '%s' (%s) with computed default dependencies", (Object)this.aspectClass.getName(), (Object)attribute.getName(), attribute.getType());
            Preconditions.checkArgument(!this.attributes.containsKey(attribute.getName()), "%s: An attribute with the name '%s' already exists.", (Object)this.aspectClass.getName(), (Object)attribute.getName());
            this.attributes.put(attribute.getName(), attribute);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragments(Class<? extends Fragment> ... configurationFragments) {
            this.configurationFragmentPolicy.requiresConfigurationFragments(ImmutableSet.copyOf(configurationFragments));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragmentsByStarlarkBuiltinName(Collection<String> configurationFragmentNames) {
            this.configurationFragmentPolicy.requiresConfigurationFragmentsByStarlarkBuiltinName(configurationFragmentNames);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMissingFragmentPolicy(Class<?> fragmentClass, ConfigurationFragmentPolicy.MissingFragmentPolicy missingFragmentPolicy) {
            this.configurationFragmentPolicy.setMissingFragmentPolicy(fragmentClass, missingFragmentPolicy);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder applyToFiles(boolean propagateOverGeneratedFiles) {
            this.applyToFiles = propagateOverGeneratedFiles;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder applyToGeneratingRules(boolean applyToGeneratingRules) {
            this.applyToGeneratingRules = applyToGeneratingRules;
            return this;
        }

        public Builder addToolchainTypes(ToolchainTypeRequirement ... toolchainTypes) {
            return this.addToolchainTypes(ImmutableSet.copyOf(toolchainTypes));
        }

        @CanIgnoreReturnValue
        public Builder addToolchainTypes(Collection<ToolchainTypeRequirement> toolchainTypes) {
            this.toolchainTypes.addAll(toolchainTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder execCompatibleWith(ImmutableSet<Label> execCompatibleWith) {
            this.execCompatibleWith = execCompatibleWith;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder execGroups(ImmutableMap<String, ExecGroup> execGroups) {
            this.execGroups = execGroups;
            return this;
        }

        public AspectDefinition build() {
            RequiredProviders requiredProviders = this.requiredProviders.build();
            if (this.applyToGeneratingRules && !requiredProviders.acceptsAny()) {
                throw new IllegalStateException("An aspect cannot simultaneously have required providers and apply to generating rules.");
            }
            return new AspectDefinition(this.aspectClass, this.advertisedProviders.build(), requiredProviders, this.requiredAspectProviders.build(), ImmutableMap.copyOf(this.attributes), ImmutableSet.copyOf(this.toolchainTypes), this.propagateAlongAttributes == null ? null : ImmutableSet.copyOf(this.propagateAlongAttributes), this.configurationFragmentPolicy.build(), this.applyToFiles, this.applyToGeneratingRules, this.requiredAspectClasses, this.execCompatibleWith, this.execGroups);
        }
    }
}

