/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectDefinition;
import com.google.devtools.build.lib.packages.AspectDescriptor;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.NativeAspectClass;
import com.google.devtools.build.lib.packages.StarlarkAspectClass;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public final class Aspect
implements DependencyFilter.AttributeInfoProvider {
    private static final LoadingCache<NativeAspectClass, LoadingCache<AspectParameters, AspectDefinition>> definitionCache = Caffeine.newBuilder().build(nativeAspectClass -> Caffeine.newBuilder().build(nativeAspectClass::getDefinition));
    private final AspectDescriptor aspectDescriptor;
    private final AspectDefinition aspectDefinition;

    private Aspect(AspectClass aspectClass, AspectDefinition aspectDefinition, AspectParameters parameters) {
        this.aspectDescriptor = new AspectDescriptor(Preconditions.checkNotNull(aspectClass), Preconditions.checkNotNull(parameters));
        this.aspectDefinition = Preconditions.checkNotNull(aspectDefinition);
    }

    public static Aspect forNative(NativeAspectClass nativeAspectClass, AspectParameters parameters) {
        AspectDefinition definition = definitionCache.get(nativeAspectClass).get(parameters);
        return new Aspect(nativeAspectClass, definition, parameters);
    }

    public static Aspect forNative(NativeAspectClass nativeAspectClass) {
        return Aspect.forNative(nativeAspectClass, AspectParameters.EMPTY);
    }

    public static Aspect forStarlark(StarlarkAspectClass starlarkAspectClass, AspectDefinition aspectDefinition, AspectParameters parameters) {
        return new Aspect(starlarkAspectClass, aspectDefinition, parameters);
    }

    public AspectClass getAspectClass() {
        return this.aspectDescriptor.getAspectClass();
    }

    public AspectParameters getParameters() {
        return this.aspectDescriptor.getParameters();
    }

    public AspectDescriptor getDescriptor() {
        return this.aspectDescriptor;
    }

    public String toString() {
        return String.format("Aspect %s", this.aspectDescriptor.toString());
    }

    public AspectDefinition getDefinition() {
        return this.aspectDefinition;
    }

    @Override
    public boolean isAttributeValueExplicitlySpecified(Attribute attribute) {
        return false;
    }

    private static final class AspectCodec
    implements ObjectCodec<Aspect> {
        private AspectCodec() {
        }

        @Override
        public Class<Aspect> getEncodedClass() {
            return Aspect.class;
        }

        @Override
        public void serialize(SerializationContext context, Aspect obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.getDescriptor(), codedOut);
            boolean nativeAspect = obj.getDescriptor().getAspectClass() instanceof NativeAspectClass;
            codedOut.writeBoolNoTag(nativeAspect);
            if (!nativeAspect) {
                context.serialize(obj.getDefinition(), codedOut);
            }
        }

        @Override
        public Aspect deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            AspectDescriptor aspectDescriptor = (AspectDescriptor)context.deserialize(codedIn);
            if (codedIn.readBool()) {
                return Aspect.forNative((NativeAspectClass)aspectDescriptor.getAspectClass(), aspectDescriptor.getParameters());
            }
            AspectDefinition aspectDefinition = (AspectDefinition)context.deserialize(codedIn);
            return Aspect.forStarlark((StarlarkAspectClass)aspectDescriptor.getAspectClass(), aspectDefinition, aspectDescriptor.getParameters());
        }
    }
}

