/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.CollectionUtils;
import com.google.devtools.build.lib.packages.AbstractAttributeMapper;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.AttributeMap;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.DelegatingAttributeMapper;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class AggregatingAttributeMapper
extends AbstractAttributeMapper {
    private AggregatingAttributeMapper(Rule rule) {
        super(rule);
    }

    public static AggregatingAttributeMapper of(Rule rule) {
        return new AggregatingAttributeMapper(rule);
    }

    private List<String> getNonConfigurableAttributes() {
        return this.rule.getRuleClassObject().getNonConfigurableAttributes();
    }

    @Override
    public void visitLabels(DependencyFilter filter, BiConsumer<Attribute, Label> consumer) {
        Type.LabelVisitor visitor = (label, attribute) -> {
            if (label != null) {
                consumer.accept(attribute, label);
            }
        };
        this.visitLabels(filter, visitor);
    }

    @Override
    <T> void visitLabels(Attribute attribute, Type<T> type, Type.LabelVisitor visitor) {
        this.visitLabels(visitor, attribute, type, true, this.ruleClass.getAttributeIndex(attribute.getName()));
    }

    void visitLabels(DependencyFilter filter, Type.LabelVisitor visitor) {
        List<Attribute> attributes = this.ruleClass.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = attributes.get(i);
            Type<?> type = attr.getType();
            if (type == BuildType.OUTPUT || type == BuildType.OUTPUT_LIST || type == BuildType.NODEP_LABEL || type == BuildType.NODEP_LABEL_LIST || !filter.test(this.rule, attr)) continue;
            this.visitLabels(visitor, attr, type, true, i);
        }
    }

    private <T> void visitLabels(Type.LabelVisitor visitor, Attribute attr, Type<T> type, boolean includeSelectKeys, int i) {
        if (type.getLabelClass() == Type.LabelClass.NONE) {
            Object rawVal;
            if (includeSelectKeys && attr.isConfigurable() && (rawVal = this.rule.getAttrIfStored(i)) instanceof BuildType.SelectorList) {
                AggregatingAttributeMapper.visitLabelsInSelect((BuildType.SelectorList)rawVal, attr, type, visitor, true, false);
            }
            return;
        }
        Object rawVal = this.rule.getAttrIfStored(i);
        if (rawVal == null && (!attr.hasComputedDefault() || this.rule.isFrozen())) {
            rawVal = attr.getDefaultValue();
        }
        if (rawVal instanceof BuildType.SelectorList) {
            AggregatingAttributeMapper.visitLabelsInSelect((BuildType.SelectorList)rawVal, attr, type, visitor, includeSelectKeys, true);
            return;
        }
        if (rawVal instanceof Attribute.ComputedDefault) {
            for (T value : ((Attribute.ComputedDefault)rawVal).getPossibleValues(type, this.rule)) {
                if (value == null) continue;
                type.visitLabels(visitor, value, attr);
            }
            return;
        }
        if (rawVal instanceof Attribute.LateBoundDefault) {
            rawVal = ((Attribute.LateBoundDefault)rawVal).getDefault();
        }
        if (rawVal == null || rawVal instanceof Collection && ((Collection)rawVal).isEmpty()) {
            return;
        }
        type.visitLabels(visitor, rawVal, attr);
    }

    private static <T> void visitLabelsInSelect(BuildType.SelectorList<T> selectorList, final Attribute attribute, final Type<T> type, final Type.LabelVisitor visitor, final boolean includeKeys, final boolean includeValues) {
        var entryProcessor = new BuildType.Selector.SelectorEntryConsumer<T>(){
            BuildType.Selector<T> selector;
            boolean hasDefault;
            boolean unconditional;

            @Override
            public void accept(Label key, @Nullable T val) {
                if (!(!includeKeys || this.unconditional || this.hasDefault && BuildType.Selector.isDefaultConditionLabel(key))) {
                    visitor.visit(key, attribute);
                }
                if (includeValues) {
                    Object value = this.selector.isValueSet(key) ? val : type.cast(attribute.getDefaultValue());
                    type.visitLabels(visitor, value, attribute);
                }
            }
        };
        List<BuildType.Selector<T>> selectors = selectorList.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            BuildType.Selector<T> selector = selectors.get(i);
            entryProcessor.selector = selector;
            entryProcessor.hasDefault = selector.hasDefault();
            entryProcessor.unconditional = selector.isUnconditional();
            selector.forEach(entryProcessor);
        }
    }

    public ImmutableSet<Label> getReachableLabels(String attributeName, boolean includeSelectKeys) {
        Integer attributeIndex = this.ruleClass.getAttributeIndex(attributeName);
        Attribute attribute = this.ruleClass.getAttribute(attributeIndex);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.visitLabels((label, attr) -> builder.add(label), attribute, attribute.getType(), includeSelectKeys, attributeIndex);
        return builder.build();
    }

    Set<Label> checkForDuplicateLabels(Attribute attribute) {
        Type.ListType<Label> attrType = BuildType.LABEL_LIST;
        Preconditions.checkArgument(attribute.getType() == attrType, "Not a label list type: %s", (Object)attribute);
        String attrName = attribute.getName();
        Object rawVal = this.rule.getAttr(attrName, attrType);
        if (!(rawVal instanceof BuildType.SelectorList)) {
            return AggregatingAttributeMapper.checkForDuplicateLabels(this.visitRawNonConfigurableAttributeValue(rawVal, attrName, attrType));
        }
        List selectors = ((BuildType.SelectorList)rawVal).getSelectors();
        if (selectors.size() == 1) {
            return AggregatingAttributeMapper.checkForDuplicateLabels(selectors.get(0).valuesCopy());
        }
        ImmutableSet.Builder<Label> duplicates = null;
        for (BuildType.Selector selector : selectors) {
            for (List labelsInSelectorValue : selector.valuesCopy()) {
                duplicates = AggregatingAttributeMapper.addDuplicateLabels(duplicates, labelsInSelectorValue);
            }
        }
        return duplicates == null ? ImmutableSet.of() : duplicates.build();
    }

    private static Set<Label> checkForDuplicateLabels(Collection<List<Label>> possibleLabels) {
        switch (possibleLabels.size()) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                List onlyPossibility = possibleLabels instanceof List ? (List)((List)possibleLabels).get(0) : possibleLabels.iterator().next();
                return CollectionUtils.duplicatedElementsOf(onlyPossibility);
            }
        }
        ImmutableSet.Builder<Label> duplicates = null;
        for (List<Label> labels : possibleLabels) {
            duplicates = AggregatingAttributeMapper.addDuplicateLabels(duplicates, labels);
        }
        return duplicates == null ? ImmutableSet.of() : duplicates.build();
    }

    private static ImmutableSet.Builder<Label> addDuplicateLabels(@Nullable ImmutableSet.Builder<Label> builder, List<Label> labels) {
        Set<Label> duplicates = CollectionUtils.duplicatedElementsOf(labels);
        if (duplicates.isEmpty()) {
            return builder;
        }
        if (builder == null) {
            builder = ImmutableSet.builder();
        }
        return builder.addAll(duplicates);
    }

    @Nullable
    public <T> Iterable<T> getConcatenatedSelectorListsOfListType(String attributeName, Type<T> type) {
        BuildType.SelectorList selectorList = this.getSelectorList(attributeName, type);
        if (selectorList != null && type instanceof Type.ListType) {
            ArrayList selectList = new ArrayList();
            for (BuildType.Selector selector : selectorList.getSelectors()) {
                ArrayList values = Lists.newArrayListWithCapacity(selector.getNumEntries());
                selector.forEach((label, value) -> values.add(value));
                selectList.add(type.concat(values));
            }
            return ImmutableList.copyOf(selectList);
        }
        return null;
    }

    public <T> Iterable<T> visitAttribute(String attributeName, Type<T> type) {
        return this.visitAttribute(attributeName, type, false);
    }

    public <T> Iterable<T> visitAttribute(String attributeName, Type<T> type, boolean mayTreatMultipleAsNone) {
        Object rawVal = this.rule.getAttr(attributeName, type);
        if (rawVal instanceof BuildType.SelectorList) {
            return AggregatingAttributeMapper.getAllValues(((BuildType.SelectorList)rawVal).getSelectors(), type, mayTreatMultipleAsNone);
        }
        return this.visitRawNonConfigurableAttributeValue(rawVal, attributeName, type);
    }

    private <T> List<T> visitRawNonConfigurableAttributeValue(Object rawVal, String attributeName, Type<T> type) {
        if (rawVal instanceof Attribute.ComputedDefault) {
            return ((Attribute.ComputedDefault)rawVal).getPossibleValues(type, this.rule);
        }
        if ("visibility".equals(attributeName) && type.equals(BuildType.NODEP_LABEL_LIST)) {
            return ImmutableList.of(type.cast(this.rule.getVisibilityDeclaredLabels()));
        }
        T value = this.getFromRawAttributeValue(rawVal, attributeName, type);
        return value == null ? ImmutableList.of() : ImmutableList.of(value);
    }

    <TException extends Exception> List<Map<String, Object>> visitAttributes(List<String> attributes, Attribute.ComputationLimiter<TException> limiter) throws TException {
        LinkedList<Map<String, Object>> depMaps = new LinkedList<Map<String, Object>>();
        AtomicInteger combinationsSoFar = new AtomicInteger(0);
        this.visitAttributesInner(attributes, depMaps, Maps.newHashMapWithExpectedSize(attributes.size()), combinationsSoFar, limiter);
        return depMaps;
    }

    private <TException extends Exception> void visitAttributesInner(List<String> attributes, List<Map<String, Object>> mappings, Map<String, Object> currentMap, AtomicInteger combinationsSoFar, Attribute.ComputationLimiter<TException> limiter) throws TException {
        if (attributes.isEmpty()) {
            limiter.onComputationCount(combinationsSoFar.incrementAndGet());
            mappings.add(new HashMap<String, Object>(currentMap));
            return;
        }
        String currentAttribute = attributes.get(0);
        Iterable<?> firstAttributePossibleValues = this.visitAttribute(currentAttribute, this.getAttributeType(currentAttribute));
        List<String> restOfAttrs = attributes.subList(1, attributes.size());
        for (Object value : firstAttributePossibleValues) {
            currentMap.put(currentAttribute, value);
            this.visitAttributesInner(restOfAttrs, mappings, currentMap, combinationsSoFar, limiter);
        }
    }

    AttributeMap createMapBackedAttributeMap(final Map<String, Object> directMap) {
        final AggregatingAttributeMapper owner = this;
        return new DelegatingAttributeMapper(owner){

            @Override
            @Nullable
            public <T> T get(String attributeName, Type<T> type) {
                owner.checkType(attributeName, type);
                if (AggregatingAttributeMapper.this.getNonConfigurableAttributes().contains(attributeName)) {
                    return owner.get(attributeName, type);
                }
                Object val = directMap.get(attributeName);
                if (val == null) {
                    Preconditions.checkArgument(directMap.containsKey(attributeName), "attribute \"%s\" isn't available in this computed default context", (Object)attributeName);
                    return null;
                }
                return type.cast(val);
            }

            public ImmutableList<String> getAttributeNames() {
                List<String> nonConfigurableAttributes = AggregatingAttributeMapper.this.getNonConfigurableAttributes();
                return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(directMap.size() + nonConfigurableAttributes.size()).addAll((Iterable)directMap.keySet())).addAll(nonConfigurableAttributes)).build();
            }
        };
    }

    private static <T> ImmutableList<T> getAllValues(List<BuildType.Selector<T>> selectors, Type<T> type, boolean mayTreatMultipleAsNone) {
        if (selectors.isEmpty()) {
            return ImmutableList.of();
        }
        if (selectors.size() == 1) {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            selectors.get(0).forEach((key, value) -> {
                if (value != null) {
                    resultBuilder.add(value);
                }
            });
            return resultBuilder.build();
        }
        ImmutableList selectorMaps = selectors.stream().map(BuildType.Selector::mapCopy).collect(ImmutableList.toImmutableList());
        ArrayDeque nodes = new ArrayDeque();
        HashMap boundKeysAndOffsets = new HashMap();
        ImmutableList.Builder result = ImmutableList.builder();
        ((Map)selectorMaps.get(0)).forEach((key, value) -> nodes.push(new ConfigurableAttrVisitationNode<Object>(0, (Label)key, value)));
        boolean foundResults = false;
        while (!nodes.isEmpty()) {
            ConfigurableAttrVisitationNode node = (ConfigurableAttrVisitationNode)nodes.pop();
            int nextOffset = node.offset + 1;
            if (nextOffset >= selectors.size()) {
                if (node.valueSoFar == null) continue;
                if (foundResults && mayTreatMultipleAsNone) {
                    return ImmutableList.of();
                }
                foundResults = true;
                result.add(node.valueSoFar);
                continue;
            }
            Map nextSelectorEntries = (Map)selectorMaps.get(nextOffset);
            BoundKeyAndOffset boundKeyAndOffset = (BoundKeyAndOffset)boundKeysAndOffsets.get(nextSelectorEntries.keySet());
            if (boundKeyAndOffset != null && boundKeyAndOffset.offset < node.offset) {
                nodes.push(new ConfigurableAttrVisitationNode<T>(nextOffset, boundKeyAndOffset.key, AggregatingAttributeMapper.concat(type, node.valueSoFar, nextSelectorEntries.get(boundKeyAndOffset.key))));
                continue;
            }
            Set currentKeys = ((Map)selectorMaps.get(node.offset)).keySet();
            boundKeysAndOffsets.put(currentKeys, new BoundKeyAndOffset(node.boundKey, node.offset));
            if (currentKeys.equals(nextSelectorEntries.keySet())) {
                nodes.push(new ConfigurableAttrVisitationNode<T>(nextOffset, node.boundKey, AggregatingAttributeMapper.concat(type, node.valueSoFar, nextSelectorEntries.get(node.boundKey))));
                continue;
            }
            nextSelectorEntries.forEach((key, value) -> nodes.push(new ConfigurableAttrVisitationNode<Object>(nextOffset, (Label)key, AggregatingAttributeMapper.concat(type, node.valueSoFar, value))));
        }
        return result.build();
    }

    private static <T> T concat(Type<T> type, T lhs, T rhs) {
        return type.concat(ImmutableList.of(lhs, rhs));
    }

    private static class BoundKeyAndOffset {
        private final Label key;
        private final int offset;

        private BoundKeyAndOffset(Label key, int offset) {
            this.key = key;
            this.offset = offset;
        }
    }

    private static class ConfigurableAttrVisitationNode<T> {
        private final int offset;
        private final Label boundKey;
        private final T valueSoFar;

        private ConfigurableAttrVisitationNode(int offset, Label boundKey, T valueSoFar) {
            this.offset = offset;
            this.boundKey = boundKey;
            this.valueSoFar = valueSoFar;
        }
    }
}

