/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.util.Fingerprint;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;

public final class AdvertisedProviderSet {
    private final boolean canHaveAnyProvider;
    private final ImmutableSet<Class<?>> builtinProviders;
    private final ImmutableSet<StarlarkProviderIdentifier> starlarkProviders;
    public static final AdvertisedProviderSet ANY = new AdvertisedProviderSet(true, ImmutableSet.of(), ImmutableSet.of());
    public static final AdvertisedProviderSet EMPTY = new AdvertisedProviderSet(false, ImmutableSet.of(), ImmutableSet.of());

    private AdvertisedProviderSet(boolean canHaveAnyProvider, ImmutableSet<Class<?>> builtinProviders, ImmutableSet<StarlarkProviderIdentifier> starlarkProviders) {
        this.canHaveAnyProvider = canHaveAnyProvider;
        this.builtinProviders = builtinProviders;
        this.starlarkProviders = starlarkProviders;
    }

    public static AdvertisedProviderSet create(ImmutableSet<Class<?>> builtinProviders, ImmutableSet<StarlarkProviderIdentifier> starlarkProviders) {
        if (builtinProviders.isEmpty() && starlarkProviders.isEmpty()) {
            return EMPTY;
        }
        return new AdvertisedProviderSet(false, builtinProviders, starlarkProviders);
    }

    public int hashCode() {
        return Objects.hash(this.canHaveAnyProvider, this.builtinProviders, this.starlarkProviders);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvertisedProviderSet)) {
            return false;
        }
        AdvertisedProviderSet that = (AdvertisedProviderSet)obj;
        return this.canHaveAnyProvider == that.canHaveAnyProvider && Objects.equals(this.builtinProviders, that.builtinProviders) && Objects.equals(this.starlarkProviders, that.starlarkProviders);
    }

    public String toString() {
        if (this.canHaveAnyProvider()) {
            return "Any Provider";
        }
        return String.format("allowed built-in providers=%s, allowed Starlark providers=%s", this.builtinProviders, this.starlarkProviders);
    }

    public boolean canHaveAnyProvider() {
        return this.canHaveAnyProvider;
    }

    public ImmutableSet<Class<?>> getBuiltinProviders() {
        return this.builtinProviders;
    }

    public ImmutableSet<StarlarkProviderIdentifier> getStarlarkProviders() {
        return this.starlarkProviders;
    }

    public void fingerprint(Fingerprint fp) {
        fp.addBoolean(this.canHaveAnyProvider);
        this.builtinProviders.forEach(clazz -> fp.addString(clazz.getCanonicalName()));
        this.starlarkProviders.forEach(starlarkProvider -> starlarkProvider.fingerprint(fp));
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean advertises(StarlarkProviderIdentifier starlarkProvider) {
        if (this.canHaveAnyProvider()) {
            return true;
        }
        return this.starlarkProviders.contains(starlarkProvider);
    }

    public static class Builder {
        private boolean canHaveAnyProvider;
        private final ArrayList<Class<?>> builtinProviders = new ArrayList();
        private final ArrayList<StarlarkProviderIdentifier> starlarkProviders = new ArrayList();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder addParent(AdvertisedProviderSet parentSet) {
            Preconditions.checkState(!this.canHaveAnyProvider, "Alias rules inherit from no other rules");
            Preconditions.checkState(!parentSet.canHaveAnyProvider(), "Cannot inherit from alias rules");
            this.builtinProviders.addAll(parentSet.getBuiltinProviders());
            this.starlarkProviders.addAll(parentSet.getStarlarkProviders());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addBuiltin(Class<?> builtinProvider) {
            this.builtinProviders.add(builtinProvider);
            return this;
        }

        public void canHaveAnyProvider() {
            Preconditions.checkState(this.builtinProviders.isEmpty() && this.starlarkProviders.isEmpty());
            this.canHaveAnyProvider = true;
        }

        public AdvertisedProviderSet build() {
            if (this.canHaveAnyProvider) {
                Preconditions.checkState(this.builtinProviders.isEmpty() && this.starlarkProviders.isEmpty());
                return ANY;
            }
            return AdvertisedProviderSet.create(ImmutableSet.copyOf(this.builtinProviders), ImmutableSet.copyOf(this.starlarkProviders));
        }

        @CanIgnoreReturnValue
        public Builder addStarlark(String providerName) {
            this.starlarkProviders.add(StarlarkProviderIdentifier.forLegacy(providerName));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStarlark(StarlarkProviderIdentifier id) {
            this.starlarkProviders.add(id);
            return this;
        }
    }
}

