/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.AttributeMap;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.Type;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class AbstractAttributeMapper
implements AttributeMap {
    final RuleClass ruleClass;
    final Rule rule;
    private final Label ruleLabel;

    protected AbstractAttributeMapper(Rule rule) {
        this.ruleClass = rule.getRuleClassObject();
        this.ruleLabel = rule.getLabel();
        this.rule = rule;
    }

    @Override
    public String getName() {
        return this.ruleLabel.getName();
    }

    @Override
    public Label getLabel() {
        return this.ruleLabel;
    }

    @Override
    @Nullable
    public <T> T get(String attributeName, Type<T> type) {
        return this.getFromRawAttributeValue(this.rule.getAttr(attributeName, type), attributeName, type);
    }

    final <T> T getFromRawAttributeValue(Object value, String attributeName, Type<T> type) {
        if (value instanceof Attribute.ComputedDefault) {
            value = ((Attribute.ComputedDefault)value).getDefault(this);
        } else if (value instanceof Attribute.LateBoundDefault) {
            value = ((Attribute.LateBoundDefault)value).getDefault();
        } else if (value instanceof BuildType.SelectorList) {
            throw new IllegalArgumentException(String.format("Unexpected configurable attribute \"%s\" in %s rule %s: expected %s, is %s", attributeName, this.ruleClass, this.ruleLabel, type, value));
        }
        return (T)value;
    }

    @Nullable
    @VisibleForTesting
    public <T> Attribute.ComputedDefault getComputedDefault(String attributeName, Type<T> type) {
        Object value = this.rule.getAttr(attributeName, type);
        if (value instanceof Attribute.ComputedDefault) {
            return (Attribute.ComputedDefault)value;
        }
        return null;
    }

    @Nullable
    public <T> Attribute.LateBoundDefault<?, T> getLateBoundDefault(String attributeName, Type<T> type) {
        Object value = this.rule.getAttr(attributeName, type);
        if (value instanceof Attribute.LateBoundDefault) {
            return (Attribute.LateBoundDefault)value;
        }
        return null;
    }

    @Override
    public Iterable<String> getAttributeNames() {
        return Lists.transform(this.ruleClass.getAttributes(), Attribute::getName);
    }

    @Override
    @Nullable
    public Type<?> getAttributeType(String attrName) {
        Attribute attr = this.getAttributeDefinition(attrName);
        return attr == null ? null : attr.getType();
    }

    @Override
    @Nullable
    public Attribute getAttributeDefinition(String attrName) {
        return this.ruleClass.getAttributeByNameMaybe(attrName);
    }

    @Override
    public boolean isAttributeValueExplicitlySpecified(String attributeName) {
        return this.rule.isAttributeValueExplicitlySpecified(attributeName);
    }

    @Override
    public String getPackageDefaultHdrsCheck() {
        return this.rule.getPackage().getDefaultHdrsCheck();
    }

    @Override
    public boolean isPackageDefaultHdrsCheckSet() {
        return this.rule.getPackage().isDefaultHdrsCheckSet();
    }

    @Override
    public Boolean getPackageDefaultTestOnly() {
        return this.rule.getPackage().getDefaultTestOnly();
    }

    @Override
    public String getPackageDefaultDeprecation() {
        return this.rule.getPackage().getDefaultDeprecation();
    }

    @Override
    public final void visitAllLabels(BiConsumer<Attribute, Label> consumer) {
        this.visitLabels(DependencyFilter.ALL_DEPS, consumer);
    }

    @Override
    public final void visitLabels(String attributeName, Consumer<Label> consumer) {
        this.visitLabels(ImmutableList.of(this.ruleClass.getAttributeByName(attributeName)), DependencyFilter.ALL_DEPS, (Attribute attr, Label label) -> consumer.accept((Label)label));
    }

    @Override
    public void visitLabels(DependencyFilter filter, BiConsumer<Attribute, Label> consumer) {
        this.visitLabels(this.ruleClass.getAttributes(), filter, consumer);
    }

    private void visitLabels(List<Attribute> attributes, DependencyFilter filter, BiConsumer<Attribute, Label> consumer) {
        Type.LabelVisitor visitor = (label, attribute) -> {
            if (label != null) {
                consumer.accept(attribute, label);
            }
        };
        for (Attribute attribute2 : attributes) {
            Type<?> type = attribute2.getType();
            if (type == BuildType.OUTPUT || type == BuildType.OUTPUT_LIST || type == BuildType.NODEP_LABEL || type == BuildType.NODEP_LABEL_LIST || !filter.test(this.rule, attribute2)) continue;
            this.visitLabels(attribute2, type, visitor);
        }
    }

    <T> void visitLabels(Attribute attribute, Type<T> type, Type.LabelVisitor visitor) {
        T value = this.get(attribute.getName(), type);
        if (value != null) {
            type.visitLabels(visitor, value, attribute);
        }
    }

    @Override
    public final boolean isConfigurable(String attributeName) {
        Attribute attrDef = this.getAttributeDefinition(attributeName);
        return attrDef != null && this.getSelectorList(attributeName, attrDef.getType()) != null;
    }

    public static <T> boolean isConfigurable(Rule rule, String attributeName, Type<T> type) {
        BuildType.SelectorList<T> selectorMaybe = rule.getSelectorList(attributeName, type);
        return selectorMaybe != null;
    }

    @Nullable
    public final <T> BuildType.SelectorList<T> getSelectorList(String attributeName, Type<T> type) {
        return this.rule.getSelectorList(attributeName, type);
    }

    void checkType(String attrName, Type<?> type) {
        Integer index = this.ruleClass.getAttributeIndex(attrName);
        if (index == null) {
            throw new IllegalArgumentException("No such attribute " + attrName + " in " + this.ruleClass + " rule " + this.ruleLabel);
        }
        Attribute attr = this.ruleClass.getAttribute(index);
        if (attr.getType() != type) {
            throw new IllegalArgumentException("Attribute " + attrName + " is of type " + attr.getType() + " and not of type " + type + " in " + this.ruleClass + " rule " + this.ruleLabel);
        }
    }

    @Override
    public boolean has(String attrName) {
        Attribute attribute = this.ruleClass.getAttributeByNameMaybe(attrName);
        return attribute != null;
    }

    @Override
    public <T> boolean has(String attrName, Type<T> type) {
        return this.getAttributeType(attrName) == type;
    }
}

