/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.clock.BlazeClock;
import com.google.devtools.build.lib.clock.Clock;
import com.google.devtools.build.lib.metrics.AutoValue_PsInfoCollector_PsInfo;
import com.google.devtools.build.lib.metrics.AutoValue_PsInfoCollector_PsSnapshot;
import com.google.devtools.build.lib.metrics.AutoValue_PsInfoCollector_ResourceSnapshot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;

public class PsInfoCollector {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Duration MIN_COLLECTION_INTERVAL = Duration.ofMillis(500L);
    private static final Clock clock = BlazeClock.instance();
    private static final PsInfoCollector instance = new PsInfoCollector();
    private PsSnapshot currentPsSnapshot;

    public static PsInfoCollector instance() {
        return instance;
    }

    private PsInfoCollector() {
    }

    public synchronized ResourceSnapshot collectResourceUsage(ImmutableSet<Long> processIds) {
        Instant now = clock.now();
        if (this.currentPsSnapshot == null || Duration.between(this.currentPsSnapshot.getCollectionTime(), now).compareTo(MIN_COLLECTION_INTERVAL) > 0) {
            this.updatePsSnapshot();
        }
        ImmutableMap.Builder<Long, Integer> pidToMemoryInKb = ImmutableMap.builder();
        for (Long pid : processIds) {
            PsInfo psInfo = this.currentPsSnapshot.getPidToPsInfo().get(pid);
            if (psInfo == null) continue;
            pidToMemoryInKb.put(pid, PsInfoCollector.collectMemoryUsageOfDescendants(psInfo, this.currentPsSnapshot));
        }
        return ResourceSnapshot.create(pidToMemoryInKb.buildOrThrow(), this.currentPsSnapshot.getCollectionTime());
    }

    private void updatePsSnapshot() {
        ImmutableMap<Long, PsInfo> pidToPsInfo = this.collectDataFromPs();
        ImmutableSetMultimap<Long, PsInfo> pidToChildrenPsInfo = pidToPsInfo.values().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(PsInfo::getParentPid, Function.identity()));
        this.currentPsSnapshot = PsSnapshot.create(pidToPsInfo, pidToChildrenPsInfo, clock.now());
    }

    @VisibleForTesting
    ImmutableMap<Long, PsInfo> collectDataFromPs() {
        try {
            Process psProcess = PsInfoCollector.buildPsProcess();
            return PsInfoCollector.collectDataFromPsProcess(psProcess);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error while executing command ps");
            return ImmutableMap.of();
        }
    }

    static ImmutableMap<Long, PsInfo> collectDataFromPsProcess(Process psProcess) {
        BufferedReader psOutput = new BufferedReader(new InputStreamReader(psProcess.getInputStream(), StandardCharsets.UTF_8));
        ImmutableMap.Builder<Long, PsInfo> psInfos = ImmutableMap.builder();
        try {
            String output = null;
            boolean isFirst = true;
            while ((output = psOutput.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                List<String> line = Splitter.on(" ").trimResults().omitEmptyStrings().splitToList(output);
                if (line.size() != 3) {
                    ((GoogleLogger.Api)logger.atWarning()).log("Unexpected length of split line %s %d", (Object)output, line.size());
                    continue;
                }
                long pid = Long.parseLong(line.get(0));
                long parentPid = Long.parseLong(line.get(1));
                int memoryInKb = Integer.parseInt(line.get(2));
                psInfos.put(pid, PsInfo.create(pid, parentPid, memoryInKb));
            }
        }
        catch (IOException | IllegalArgumentException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error while parsing psOutput: %s", psOutput);
        }
        return psInfos.buildOrThrow();
    }

    private static Process buildPsProcess() throws IOException {
        return new ProcessBuilder("ps", "-e", "-o", "pid,ppid,rss").start();
    }

    private static int collectMemoryUsageOfDescendants(PsInfo psInfo, PsSnapshot psSnapshot) {
        int currentMemoryInKb = psInfo.getMemoryInKb();
        for (PsInfo childrenPsInfo : psSnapshot.getPidToChildrenPsInfo().get((Object)psInfo.getPid())) {
            currentMemoryInKb += PsInfoCollector.collectMemoryUsageOfDescendants(childrenPsInfo, psSnapshot);
        }
        return currentMemoryInKb;
    }

    @AutoValue
    public static abstract class ResourceSnapshot {
        public abstract ImmutableMap<Long, Integer> getPidToMemoryInKb();

        public abstract Instant getCollectionTime();

        public static ResourceSnapshot create(ImmutableMap<Long, Integer> pidToMemoryInKb, Instant collectionTime) {
            return new AutoValue_PsInfoCollector_ResourceSnapshot(pidToMemoryInKb, collectionTime);
        }
    }

    @AutoValue
    static abstract class PsSnapshot {
        PsSnapshot() {
        }

        abstract ImmutableMap<Long, PsInfo> getPidToPsInfo();

        abstract ImmutableSetMultimap<Long, PsInfo> getPidToChildrenPsInfo();

        abstract Instant getCollectionTime();

        static PsSnapshot create(ImmutableMap<Long, PsInfo> pidToPsInfo, ImmutableSetMultimap<Long, PsInfo> pidToChildrenPsInfo, Instant collectionTime) {
            return new AutoValue_PsInfoCollector_PsSnapshot(pidToPsInfo, pidToChildrenPsInfo, collectionTime);
        }
    }

    @AutoValue
    static abstract class PsInfo {
        PsInfo() {
        }

        public abstract long getPid();

        public abstract long getParentPid();

        public abstract int getMemoryInKb();

        public static PsInfo create(long pid, long parentPid, int memoryinKb) {
            return new AutoValue_PsInfoCollector_PsInfo(pid, parentPid, memoryinKb);
        }
    }
}

