/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.jni;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.ByteStreams;
import com.google.devtools.build.lib.util.OS;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class JniLoader {
    private static final GoogleLogger logger;
    private static final boolean JNI_AVAILABLE;

    private static void loadLibrary(String resourceName) throws IOException {
        Path dir = null;
        Path tempFile = null;
        try {
            dir = Files.createTempDirectory("bazel-jni.", new FileAttribute[0]);
            int slash = resourceName.lastIndexOf(47);
            Preconditions.checkArgument(slash != -1, "resourceName must contain two path components");
            tempFile = dir.resolve(resourceName.substring(slash + 1));
            ClassLoader loader = JniLoader.class.getClassLoader();
            try (InputStream resource = loader.getResourceAsStream(resourceName);){
                if (resource == null) {
                    throw new UnsatisfiedLinkError("Resource " + resourceName + " not in JAR");
                }
                try (FileOutputStream diskFile = new FileOutputStream(tempFile.toString());){
                    ByteStreams.copy(resource, diskFile);
                }
            }
            System.load(tempFile.toString());
            if (OS.getCurrent() != OS.WINDOWS) {
                Files.delete(tempFile);
                tempFile = null;
                Files.delete(dir);
                dir = null;
            }
        }
        catch (IOException e) {
            try {
                if (tempFile != null) {
                    Files.deleteIfExists(tempFile);
                }
                if (dir != null) {
                    Files.delete(dir);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    protected JniLoader() {
    }

    public static void loadJni() {
    }

    public static boolean isJniAvailable() {
        return JNI_AVAILABLE;
    }

    static {
        boolean jniAvailable;
        logger = GoogleLogger.forEnclosingClass();
        try {
            switch (OS.getCurrent()) {
                case LINUX: 
                case FREEBSD: 
                case OPENBSD: 
                case UNKNOWN: {
                    JniLoader.loadLibrary("main/native/libunix_jni.so");
                    break;
                }
                case DARWIN: {
                    JniLoader.loadLibrary("main/native/libunix_jni.dylib");
                    break;
                }
                case WINDOWS: {
                    try {
                        System.loadLibrary("windows_jni");
                        break;
                    }
                    catch (UnsatisfiedLinkError e) {
                        try {
                            JniLoader.loadLibrary("main/native/windows/windows_jni.dll");
                            break;
                        }
                        catch (IOException e2) {
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e2)).log("Failed to load JNI library from resource");
                            throw e;
                        }
                    }
                }
                default: {
                    throw new AssertionError((Object)"switch statement out of sync with OS values");
                }
            }
            jniAvailable = true;
        }
        catch (IOException | UnsatisfiedLinkError e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to load JNI library");
            jniAvailable = false;
        }
        JNI_AVAILABLE = jniAvailable;
    }
}

