/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.io;

import com.google.devtools.build.lib.io.InconsistentFilesystemException;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.skyframe.DetailedException;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.vfs.RootedPath;

public final class ProcessPackageDirectoryException
extends Exception
implements DetailedException {
    private final DetailedExitCode detailedExitCode = DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(this.getMessage()).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.TRANSIENT_INCONSISTENT_FILESYSTEM_ERROR)).build());

    public ProcessPackageDirectoryException(RootedPath directory, InconsistentFilesystemException e) {
        super("Directory '" + directory.asPath().getPathString() + "' could not be processed: " + e.getMessage(), e);
    }

    @Override
    public DetailedExitCode getDetailedExitCode() {
        return this.detailedExitCode;
    }
}

