/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import java.util.ArrayList;
import java.util.List;

public class StoredEventHandler
implements ExtendedEventHandler {
    private final List<Event> events = new ArrayList<Event>();
    private final List<ExtendedEventHandler.Postable> posts = new ArrayList<ExtendedEventHandler.Postable>();
    private boolean hasErrors;

    public synchronized ImmutableList<Event> getEvents() {
        return ImmutableList.copyOf(this.events);
    }

    public synchronized ImmutableList<ExtendedEventHandler.Postable> getPosts() {
        return ImmutableList.copyOf(this.posts);
    }

    public synchronized boolean isEmpty() {
        return this.events.isEmpty() && this.posts.isEmpty();
    }

    @Override
    public synchronized void handle(Event e) {
        this.hasErrors |= e.getKind() == EventKind.ERROR;
        this.events.add(e);
    }

    @Override
    public synchronized void post(ExtendedEventHandler.Postable e) {
        this.posts.add(e);
    }

    public synchronized void replayOn(ExtendedEventHandler eventHandler) {
        Event.replayEventsOn((EventHandler)eventHandler, this.events);
        for (ExtendedEventHandler.Postable obj : this.posts) {
            eventHandler.post(obj);
        }
    }

    public synchronized boolean hasErrors() {
        return this.hasErrors;
    }

    public synchronized void clear() {
        this.events.clear();
        this.posts.clear();
        this.hasErrors = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("events", this.events).add("posts", this.posts).add("hasErrors", this.hasErrors).toString();
    }
}

