/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import java.io.OutputStream;
import java.util.Arrays;

public final class ReporterStream
extends OutputStream {
    private final EventHandler handler;
    private final EventKind eventKind;

    public ReporterStream(EventHandler handler, EventKind eventKind) {
        this.handler = Preconditions.checkNotNull(handler);
        this.eventKind = Preconditions.checkNotNull(eventKind);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int b) {
        this.handler.handle(Event.of(this.eventKind, null, new byte[]{(byte)b}));
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int len) {
        this.handler.handle(Event.of(this.eventKind, null, Arrays.copyOfRange(bytes, offset, offset + len)));
    }
}

