/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import com.google.devtools.build.lib.events.OutputFilter;
import com.google.devtools.build.lib.events.ReporterStream;
import com.google.devtools.build.lib.util.io.OutErr;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Location;

public final class Reporter
implements ExtendedEventHandler {
    private final ConcurrentLinkedQueue<EventHandler> eventHandlers = new ConcurrentLinkedQueue();
    private EventBus eventBus;
    private final OutErr outErrToReporter = Reporter.outErrForReporter(this);
    private volatile OutputFilter outputFilter = OutputFilter.OUTPUT_EVERYTHING;
    private EventHandler ansiAllowingHandler;
    private EventHandler ansiStrippingHandler;
    private boolean ansiAllowingHandlerRegistered;

    public Reporter(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Reporter(Reporter template) {
        this.eventHandlers.addAll(template.eventHandlers);
        this.eventBus = template.eventBus;
    }

    public Reporter(EventBus eventBus, EventHandler ... handlers) {
        this.eventBus = eventBus;
        for (EventHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public static OutErr outErrForReporter(EventHandler rep) {
        return OutErr.create(new ReporterStream(rep, EventKind.STDOUT), new ReporterStream(rep, EventKind.STDERR));
    }

    public OutErr getOutErr() {
        return this.outErrToReporter;
    }

    public void addHandler(EventHandler handler) {
        Preconditions.checkNotNull(handler);
        this.eventHandlers.add(handler);
    }

    public void removeHandler(EventHandler handler) {
        Preconditions.checkNotNull(handler);
        this.eventHandlers.remove(handler);
    }

    @Override
    public void handle(Event e) {
        if (e.getKind() != EventKind.ERROR && e.getKind() != EventKind.DEBUG && e.getTag() != null && !this.showOutput(e.getTag())) {
            return;
        }
        for (EventHandler handler : this.eventHandlers) {
            handler.handle(e);
        }
    }

    @Override
    public void post(ExtendedEventHandler.Postable obj) {
        if (this.eventBus != null) {
            this.eventBus.post(obj);
        }
        for (EventHandler eventHandler : this.eventHandlers) {
            if (!(eventHandler instanceof ExtendedEventHandler)) continue;
            ((ExtendedEventHandler)eventHandler).post(obj);
        }
    }

    public void clearEventBus() {
        this.eventBus = null;
    }

    public void startTask(Location location, String message) {
        this.handle(Event.of(EventKind.START, location, message));
    }

    public void finishTask(Location location, String message) {
        this.handle(Event.of(EventKind.FINISH, location, message));
    }

    public void error(Location location, String message) {
        this.error(location, message, null);
    }

    public void error(Location location, String message, @Nullable Throwable error) {
        this.handle(Event.error(location, message));
        if (error != null) {
            error.printStackTrace(new PrintStream(this.getOutErr().getErrorStream()));
        }
    }

    public boolean showOutput(String tag) {
        return this.outputFilter.showOutput(tag);
    }

    public void setOutputFilter(OutputFilter outputFilter) {
        this.outputFilter = outputFilter;
    }

    public synchronized void registerAnsiAllowingHandler(EventHandler ansiStrippingHandler, EventHandler ansiAllowingHandler) {
        this.ansiAllowingHandler = ansiAllowingHandler;
        this.ansiStrippingHandler = ansiStrippingHandler;
        this.ansiAllowingHandlerRegistered = true;
    }

    public synchronized void switchToAnsiAllowingHandler() {
        if (this.ansiAllowingHandlerRegistered) {
            this.removeHandler(this.ansiStrippingHandler);
            this.addHandler(this.ansiAllowingHandler);
            this.ansiStrippingHandler = null;
            this.ansiAllowingHandler = null;
            this.ansiAllowingHandlerRegistered = false;
        }
    }
}

