/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.devtools.build.lib.events.AbstractEventHandler;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.util.io.OutErr;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class PrintingEventHandler
extends AbstractEventHandler
implements EventHandler {
    public static final PrintingEventHandler ERRORS_AND_WARNINGS_TO_STDERR = new PrintingEventHandler(EventKind.ERRORS_AND_WARNINGS_AND_OUTPUT);
    public static final PrintingEventHandler ERRORS_TO_STDERR = new PrintingEventHandler(EventKind.ERRORS_AND_OUTPUT);
    private OutErr outErr;

    public PrintingEventHandler(OutErr outErr, Set<EventKind> mask) {
        super(mask);
        this.outErr = outErr;
    }

    public PrintingEventHandler(Set<EventKind> mask) {
        this(OutErr.SYSTEM_OUT_ERR, mask);
    }

    public OutErr setOutErr(OutErr outErr) {
        OutErr prev = this.outErr;
        this.outErr = outErr;
        return prev;
    }

    @Override
    public void handle(Event event) {
        if (!this.getEventMask().contains((Object)event.getKind())) {
            this.handleFollowUpEvents(event);
            return;
        }
        try {
            switch (event.getKind()) {
                case STDOUT: {
                    this.outErr.getOutputStream().write(event.getMessageBytes());
                    this.outErr.getOutputStream().flush();
                    break;
                }
                case STDERR: {
                    this.outErr.getErrorStream().write(event.getMessageBytes());
                    this.outErr.getErrorStream().flush();
                    break;
                }
                default: {
                    StringBuilder builder = new StringBuilder();
                    builder.append((Object)event.getKind()).append(": ");
                    if (event.getLocation() != null) {
                        builder.append(event.getLocation()).append(": ");
                    }
                    builder.append(event.getMessage()).append("\n");
                    this.outErr.getErrorStream().write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    this.outErr.getErrorStream().flush();
                    break;
                }
            }
        }
        catch (IOException e) {
            this.outErr.printErrLn(e.getMessage());
        }
        this.handleFollowUpEvents(event);
    }

    private void handleFollowUpEvents(Event event) {
        byte[] stdout;
        byte[] stderr = event.getStdErr();
        if (stderr != null) {
            this.handle(Event.of(EventKind.STDERR, null, stderr));
        }
        if ((stdout = event.getStdOut()) != null) {
            this.handle(Event.of(EventKind.STDOUT, null, stdout));
        }
    }
}

