/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import java.util.regex.Pattern;

public interface OutputFilter {
    public static final OutputFilter OUTPUT_EVERYTHING = new OutputFilter(){

        @Override
        public boolean showOutput(String tag) {
            return true;
        }
    };
    public static final OutputFilter OUTPUT_NOTHING = new OutputFilter(){

        @Override
        public boolean showOutput(String tag) {
            return false;
        }
    };

    public boolean showOutput(String var1);

    public static final class RegexOutputFilter
    implements OutputFilter {
        private final Pattern pattern;

        public static OutputFilter forRegex(String regex) {
            return new RegexOutputFilter(Pattern.compile(regex));
        }

        public static OutputFilter forPattern(Pattern pattern) {
            return new RegexOutputFilter(pattern);
        }

        private RegexOutputFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean showOutput(String tag) {
            return this.pattern.matcher(tag).find();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

