/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;

public enum EventKind {
    FATAL,
    ERROR,
    WARNING,
    INFO,
    PROGRESS,
    DEBUG,
    START,
    FINISH,
    SUBCOMMAND,
    STDOUT,
    STDERR,
    PASS,
    FAIL,
    TIMEOUT,
    CANCELLED,
    DEPCHECKER;

    public static final ImmutableSet<EventKind> ALL_EVENTS;
    public static final ImmutableSet<EventKind> OUTPUT;
    public static final ImmutableSet<EventKind> ERRORS;
    public static final ImmutableSet<EventKind> ERRORS_AND_WARNINGS;
    public static final ImmutableSet<EventKind> ERRORS_WARNINGS_AND_INFO;
    public static final ImmutableSet<EventKind> ERRORS_AND_OUTPUT;
    public static final ImmutableSet<EventKind> ERRORS_AND_WARNINGS_AND_OUTPUT;

    static {
        ALL_EVENTS = Sets.immutableEnumSet(EnumSet.allOf(EventKind.class));
        OUTPUT = Sets.immutableEnumSet((Enum)STDOUT, (Enum[])new EventKind[]{STDERR});
        ERRORS = Sets.immutableEnumSet((Enum)FATAL, (Enum[])new EventKind[]{ERROR, FAIL, TIMEOUT});
        ERRORS_AND_WARNINGS = Sets.immutableEnumSet((Enum)FATAL, (Enum[])new EventKind[]{ERROR, WARNING, DEBUG, FAIL, TIMEOUT});
        ERRORS_WARNINGS_AND_INFO = Sets.immutableEnumSet((Enum)FATAL, (Enum[])new EventKind[]{ERROR, WARNING, DEBUG, PASS, FAIL, TIMEOUT, INFO});
        ERRORS_AND_OUTPUT = Sets.immutableEnumSet((Enum)FATAL, (Enum[])new EventKind[]{ERROR, FAIL, TIMEOUT, STDOUT, STDERR});
        ERRORS_AND_WARNINGS_AND_OUTPUT = Sets.immutableEnumSet((Enum)FATAL, (Enum[])new EventKind[]{ERROR, WARNING, DEBUG, FAIL, TIMEOUT, STDOUT, STDERR});
    }
}

