/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.events.AbstractEventHandler;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class EventCollector
extends AbstractEventHandler
implements Iterable<Event> {
    private final Collection<Event> collected;

    public EventCollector(Set<EventKind> mask) {
        this(mask, new ArrayList<Event>());
    }

    public EventCollector() {
        this(EventKind.ALL_EVENTS, new ArrayList<Event>());
    }

    public EventCollector(EventKind ... mask) {
        this(ImmutableSet.copyOf(mask), new ArrayList<Event>());
    }

    public EventCollector(Set<EventKind> mask, Collection<Event> collected) {
        super(mask);
        this.collected = collected;
    }

    @Override
    public synchronized void handle(Event event) {
        if (this.getEventMask().contains((Object)event.getKind())) {
            this.collected.add(event);
        }
        if (event.getStdErr() != null) {
            this.handle(Event.of(EventKind.STDERR, null, event.getStdErr()));
        }
        if (event.getStdOut() != null) {
            this.handle(Event.of(EventKind.STDOUT, null, event.getStdOut()));
        }
    }

    @Override
    public Iterator<Event> iterator() {
        return this.collected.iterator();
    }

    public Iterable<Event> filtered(EventKind eventKind) {
        return Iterables.filter(this.collected, event -> event.getKind() == eventKind);
    }

    public synchronized int count() {
        return this.collected.size();
    }

    public synchronized void clear() {
        this.collected.clear();
    }

    public synchronized String toString() {
        return "EventCollector: " + Iterables.toString(this.collected);
    }
}

