/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import com.google.devtools.build.lib.events.Reportable;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.SyntaxError;

@CheckReturnValue
@Immutable
public final class Event
implements Reportable {
    private final EventKind kind;
    private final Object message;
    private final ImmutableClassToInstanceMap<Object> properties;
    private int hashCode;

    private Event(EventKind kind, Object message, ImmutableClassToInstanceMap<Object> properties) {
        this.kind = Preconditions.checkNotNull(kind);
        this.message = Preconditions.checkNotNull(message);
        this.properties = Preconditions.checkNotNull(properties);
    }

    @Override
    public void reportTo(ExtendedEventHandler handler) {
        handler.handle(this);
    }

    @Override
    public boolean storeForReplay() {
        return this.kind != EventKind.PROGRESS && this.kind != EventKind.WARNING && this.kind != EventKind.INFO && this.kind != EventKind.DEBUG;
    }

    public EventKind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message instanceof String ? (String)this.message : new String((byte[])this.message, StandardCharsets.UTF_8);
    }

    public byte[] getMessageBytes() {
        return this.message instanceof byte[] ? (byte[])this.message : ((String)this.message).getBytes(StandardCharsets.UTF_8);
    }

    @Nullable
    public <T> T getProperty(Class<T> type) {
        return this.properties.getInstance(type);
    }

    public <T> Event withProperty(Class<T> type, @Nullable T propertyValue) {
        Iterable<Object> orderedKeys;
        boolean containsKey = this.properties.containsKey(type);
        if (!containsKey && propertyValue != null) {
            orderedKeys = Stream.concat(this.properties.keySet().stream(), Stream.of(type)).sorted(Comparator.comparing(Class::getName)).collect(ImmutableList.toImmutableList());
        } else if (containsKey) {
            orderedKeys = this.properties.keySet();
        } else {
            return this;
        }
        ImmutableClassToInstanceMap.Builder<Object> newProperties = new ImmutableClassToInstanceMap.Builder<Object>();
        for (Class key : orderedKeys) {
            if (key.equals(type)) {
                if (propertyValue == null) continue;
                newProperties.put(type, propertyValue);
                continue;
            }
            this.addToBuilder(newProperties, key);
        }
        return new Event(this.kind, this.message, newProperties.build());
    }

    private <T> void addToBuilder(ImmutableClassToInstanceMap.Builder<Object> builder, Class<T> key) {
        builder.put(key, Preconditions.checkNotNull(this.properties.getInstance(key)));
    }

    @Override
    public Event withTag(@Nullable String tag) {
        if (Objects.equals(tag, this.getProperty(String.class))) {
            return this;
        }
        return this.withProperty(String.class, tag);
    }

    public Event withProcessOutput(ProcessOutput processOutput) {
        return this.withProperty(ProcessOutput.class, processOutput);
    }

    @Nullable
    public String getTag() {
        return this.getProperty(String.class);
    }

    @Nullable
    public ProcessOutput getProcessOutput() {
        return this.getProperty(ProcessOutput.class);
    }

    @Nullable
    public byte[] getStdOut() {
        ProcessOutput processOutput = this.getProperty(ProcessOutput.class);
        if (processOutput == null) {
            return null;
        }
        return processOutput.getStdOut();
    }

    @Nullable
    public byte[] getStdErr() {
        ProcessOutput processOutput = this.getProperty(ProcessOutput.class);
        if (processOutput == null) {
            return null;
        }
        return processOutput.getStdErr();
    }

    @Nullable
    public Location getLocation() {
        return this.getProperty(Location.class);
    }

    public String toString() {
        Location location = this.getLocation();
        return this.kind + " " + (location != null ? location.toString() : "<no location>") + ": " + this.getMessage();
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = Objects.hash(new Object[]{this.kind, this.message instanceof String ? this.message : Integer.valueOf(Arrays.hashCode((byte[])this.message)), this.properties});
        }
        return h2;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        Event that = (Event)other;
        return Objects.equals((Object)this.kind, (Object)that.kind) && this.message.getClass().equals(that.message.getClass()) && (this.message instanceof String ? Objects.equals(this.message, that.message) : Arrays.equals((byte[])this.message, (byte[])that.message)) && Objects.equals(this.properties, that.properties);
    }

    public static Event of(EventKind kind, String message) {
        return new Event(kind, message, ImmutableClassToInstanceMap.of());
    }

    public static <T> Event of(EventKind kind, String message, Class<T> propertyType, T propertyValue) {
        return new Event(kind, message, ImmutableClassToInstanceMap.of(propertyType, propertyValue));
    }

    public static Event of(EventKind kind, byte[] messageBytes) {
        return new Event(kind, messageBytes, ImmutableClassToInstanceMap.of());
    }

    public static <T> Event of(EventKind kind, byte[] messageBytes, Class<T> propertyType, T propertyValue) {
        return new Event(kind, messageBytes, ImmutableClassToInstanceMap.of(propertyType, propertyValue));
    }

    public static Event of(EventKind kind, @Nullable Location location, String message) {
        return location == null ? Event.of(kind, message) : Event.of(kind, message, Location.class, location);
    }

    public static Event of(EventKind kind, @Nullable Location location, byte[] messageBytes) {
        return location == null ? Event.of(kind, messageBytes) : Event.of(kind, messageBytes, Location.class, location);
    }

    public static Event fatal(String message) {
        return Event.of(EventKind.FATAL, message);
    }

    public static Event error(@Nullable Location location, String message) {
        return location == null ? Event.of(EventKind.ERROR, message) : Event.of(EventKind.ERROR, message, Location.class, location);
    }

    public static Event error(String message) {
        return Event.of(EventKind.ERROR, message);
    }

    public static Event warn(@Nullable Location location, String message) {
        return location == null ? Event.of(EventKind.WARNING, message) : Event.of(EventKind.WARNING, message, Location.class, location);
    }

    public static Event warn(String message) {
        return Event.of(EventKind.WARNING, message);
    }

    public static Event info(@Nullable Location location, String message) {
        return location == null ? Event.of(EventKind.INFO, message) : Event.of(EventKind.INFO, message, Location.class, location);
    }

    public static Event info(String message) {
        return Event.of(EventKind.INFO, message);
    }

    public static Event progress(@Nullable Location location, String message) {
        return location == null ? Event.of(EventKind.PROGRESS, message) : Event.of(EventKind.PROGRESS, message, Location.class, location);
    }

    public static Event progress(String message) {
        return Event.of(EventKind.PROGRESS, message);
    }

    public static Event debug(@Nullable Location location, String message) {
        return location == null ? Event.of(EventKind.DEBUG, message) : Event.of(EventKind.DEBUG, message, Location.class, location);
    }

    public static Event debug(String message) {
        return Event.of(EventKind.DEBUG, message);
    }

    public static void replayEventsOn(EventHandler handler, Iterable<Event> events) {
        for (Event event : events) {
            handler.handle(event);
        }
    }

    public static void replayEventsOn(EventHandler handler, List<SyntaxError> errors) {
        for (SyntaxError error : errors) {
            handler.handle(Event.error(error.location(), error.message()));
        }
    }

    public static StarlarkThread.PrintHandler makeDebugPrintHandler(EventHandler h2) {
        return (thread, msg) -> h2.handle(Event.debug(thread.getCallerLocation(), msg));
    }

    public static interface ProcessOutput {
        public String getStdOutPath();

        public long getStdOutSize() throws IOException;

        public byte[] getStdOut();

        public String getStdErrPath();

        public long getStdErrSize() throws IOException;

        public byte[] getStdErr();
    }
}

