/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.events;

import com.google.devtools.build.lib.events.DelegatingEventHandler;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class ErrorSensingEventHandler<T>
extends DelegatingEventHandler {
    @Nullable
    private final Class<T> errorPropertyClass;
    private final AtomicReference<T> errorProperty = new AtomicReference<Object>(null);
    private volatile boolean hasErrors;

    public ErrorSensingEventHandler(ExtendedEventHandler eventHandler, @Nullable Class<T> errorPropertyClass) {
        super(eventHandler);
        this.errorPropertyClass = errorPropertyClass;
    }

    public static ErrorSensingEventHandler<Void> withoutPropertyValueTracking(ExtendedEventHandler eventHandler) {
        return new ErrorSensingEventHandler<Void>(eventHandler, null);
    }

    @Override
    public void handle(Event e) {
        if (e.getKind() == EventKind.ERROR) {
            T propertyValue;
            this.hasErrors = true;
            if (this.errorPropertyClass != null && (propertyValue = e.getProperty(this.errorPropertyClass)) != null) {
                this.errorProperty.compareAndSet(null, propertyValue);
            }
        }
        super.handle(e);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Nullable
    public T getErrorProperty() {
        return this.errorProperty.get();
    }
}

