/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import java.util.concurrent.Callable;

public final class Uninterruptibles {
    public static final <T> T callUninterruptibly(Callable<T> callable) throws Exception {
        boolean interrupted = false;
        while (true) {
            try {
                T t2 = callable.call();
                return t2;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

