/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.build.lib.concurrent.ErrorClassifier;
import com.google.devtools.build.lib.concurrent.PriorityWorkerPool;
import com.google.devtools.build.lib.concurrent.QuiescingExecutor;
import java.lang.ref.Cleaner;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;

public final class TieredPriorityExecutor
implements QuiescingExecutor {
    private static final Cleaner poolCleaner = Cleaner.create();
    private final PriorityWorkerPool pool;
    private volatile Throwable catastrophe;

    public TieredPriorityExecutor(String name, int poolSize, int cpuPermits, ErrorClassifier errorClassifier) {
        Preconditions.checkArgument(poolSize >= cpuPermits, "expected poolSize=%s >= cpuPermits=%s", poolSize, cpuPermits);
        this.pool = new PriorityWorkerPool(poolCleaner, name, poolSize, cpuPermits, errorClassifier);
        poolCleaner.register(this, this.pool::dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        try {
            this.pool.execute(task);
        }
        catch (Throwable uncaught) {
            this.pool.cancel();
            this.catastrophe = uncaught;
            Object object = this.pool.quiescenceMonitor();
            synchronized (object) {
                this.pool.quiescenceMonitor().notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitQuiescence(boolean interruptWorkers) throws InterruptedException {
        InterruptedException interruptedException = null;
        while (true) {
            try {
                Object object = this.pool.quiescenceMonitor();
                synchronized (object) {
                    while (!this.pool.isQuiescent() && this.catastrophe == null) {
                        this.pool.quiescenceMonitor().wait();
                    }
                }
            }
            catch (InterruptedException e) {
                interruptedException = e;
                if (!interruptWorkers) continue;
                this.pool.cancel();
                continue;
            }
            break;
        }
        TieredPriorityExecutor.throwIfNonNull(this.catastrophe);
        Throwable unhandled = this.pool.unhandled();
        this.pool.reset();
        TieredPriorityExecutor.throwIfNonNull(unhandled);
        if (interruptedException != null) {
            throw interruptedException;
        }
    }

    @Override
    public void dependOnFuture(ListenableFuture<?> future) {
        throw new UnsupportedOperationException();
    }

    @Override
    @VisibleForTesting
    public CountDownLatch getExceptionLatchForTestingOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    @VisibleForTesting
    public CountDownLatch getInterruptionLatchForTestingOnly() {
        throw new UnsupportedOperationException();
    }

    public static boolean tryDoQueuedWork() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof PriorityWorkerPool.WorkerThread)) {
            return false;
        }
        return ((PriorityWorkerPool.WorkerThread)thread).tryDoQueuedWork();
    }

    public int poolSize() {
        return this.pool.poolSize();
    }

    public int cpuPermits() {
        return this.pool.cpuPermits();
    }

    public boolean hasCatastrophe() {
        return this.catastrophe != null;
    }

    @VisibleForTesting
    PhantomReference<ForkJoinPool> registerPoolDisposalMonitorForTesting(ReferenceQueue<ForkJoinPool> referenceQueue) {
        return this.pool.registerPoolDisposalMonitorForTesting(referenceQueue);
    }

    @VisibleForTesting
    boolean isCancelledForTestingOnly() {
        return this.pool.isCancelled();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("pool", this.pool).add("catastrophe", this.catastrophe).toString();
    }

    private static void throwIfNonNull(@Nullable Throwable e) {
        if (e == null) {
            return;
        }
        Throwables.throwIfUnchecked(e);
        throw new IllegalArgumentException("Unexpected checked exception.", e);
    }
}

