/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import java.util.Arrays;
import sun.misc.Unsafe;

final class TaskFifo {
    private static final Integer SKIP_SLOW_APPENDER = 1;
    @VisibleForTesting
    static final int CAPACITY = 16384;
    private static final int CAPACITY_MASK = 16383;
    private final Object[] queue = new Object[16384];
    private final long appendIndexAddress;
    private final long takeIndexAddress;
    private final long sizeAddress;
    private static final Unsafe UNSAFE = UnsafeProvider.unsafe();
    private static final int TASKS_BASE = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
    private static final int TASKS_SCALE = Unsafe.ARRAY_OBJECT_INDEX_SCALE;

    TaskFifo(long sizeAddress, long appendIndexAddress, long takeIndexAddress) {
        this.sizeAddress = sizeAddress;
        this.appendIndexAddress = appendIndexAddress;
        this.takeIndexAddress = takeIndexAddress;
        UNSAFE.putInt(null, sizeAddress, 0);
        UNSAFE.putInt(null, appendIndexAddress, 0);
        UNSAFE.putInt(null, takeIndexAddress, 0);
    }

    boolean tryAppend(Runnable task) {
        if (UNSAFE.getAndAddInt(null, this.sizeAddress, 1) >= 16383) {
            UNSAFE.getAndAddInt(null, this.sizeAddress, -1);
            return false;
        }
        int offset;
        while (!UNSAFE.compareAndSwapObject(this.queue, offset = TaskFifo.getQueueOffset(UNSAFE.getAndAddInt(null, this.appendIndexAddress, 1)), null, task)) {
            while (true) {
                int newCount;
                Object snapshot;
                if ((snapshot = UNSAFE.getObject(this.queue, offset)) == null) {
                    if (!UNSAFE.compareAndSwapObject(this.queue, offset, null, task)) continue;
                    return true;
                }
                Object target = snapshot instanceof Integer ? ((newCount = (Integer)snapshot - 1) == 0 ? null : Integer.valueOf(newCount)) : (snapshot instanceof Runnable ? new TaskWithSkippedAppends((Runnable)snapshot, 1) : ((TaskWithSkippedAppends)snapshot).incrementSkips());
                if (UNSAFE.compareAndSwapObject(this.queue, offset, snapshot, target)) break;
            }
        }
        return true;
    }

    Runnable take() {
        while (true) {
            int offset = TaskFifo.getQueueOffset(UNSAFE.getAndAddInt(null, this.takeIndexAddress, 1));
            while (true) {
                Object snapshot;
                if ((snapshot = UNSAFE.getObject(this.queue, offset)) instanceof Runnable) {
                    if (!UNSAFE.compareAndSwapObject(this.queue, offset, snapshot, null)) continue;
                    UNSAFE.getAndAddInt(null, this.sizeAddress, -1);
                    return (Runnable)snapshot;
                }
                Object target = snapshot == null ? SKIP_SLOW_APPENDER : (snapshot instanceof Integer ? Integer.valueOf((Integer)snapshot + 1) : ((TaskWithSkippedAppends)snapshot).decrementSkips());
                if (UNSAFE.compareAndSwapObject(this.queue, offset, snapshot, target)) break;
            }
        }
    }

    int size() {
        return UNSAFE.getIntVolatile(null, this.sizeAddress);
    }

    void clear() {
        UNSAFE.putInt(null, this.sizeAddress, 0);
        UNSAFE.putInt(null, this.appendIndexAddress, 0);
        UNSAFE.putInt(null, this.takeIndexAddress, 0);
        Arrays.fill(this.queue, null);
    }

    public String toString() {
        int appendIndex = UNSAFE.getIntVolatile(null, this.appendIndexAddress);
        int takeIndex = UNSAFE.getIntVolatile(null, this.takeIndexAddress);
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("size", UNSAFE.getIntVolatile(null, this.sizeAddress)).add("appendIndex", String.format("%d (%d)", appendIndex, appendIndex & 0x3FFF)).add("takeIndex", String.format("%d (%d)", takeIndex, takeIndex & 0x3FFF));
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < 16384; ++i) {
            Object elt;
            if (i > 0) {
                buf.append(',');
            }
            if (i % 10 == 0) {
                buf.append(i).append(':');
            }
            if ((elt = this.queue[i]) == null) {
                buf.append('0');
                continue;
            }
            if (elt instanceof Runnable) {
                buf.append('1');
                continue;
            }
            if (elt instanceof Integer) {
                buf.append('S').append(elt);
                continue;
            }
            buf.append('T').append(((TaskWithSkippedAppends)elt).skippedAppendCount);
        }
        helper.add("queue", buf.append(']').toString());
        return helper.toString();
    }

    @VisibleForTesting
    Object[] getQueueForTesting() {
        return this.queue;
    }

    private static int getQueueOffset(int index) {
        return TASKS_BASE + TASKS_SCALE * (index & 0x3FFF);
    }

    @VisibleForTesting
    static class TaskWithSkippedAppends {
        private final Runnable task;
        private final int skippedAppendCount;

        private TaskWithSkippedAppends(Runnable task, int skippedAppendCount) {
            this.task = task;
            this.skippedAppendCount = skippedAppendCount;
        }

        private Object decrementSkips() {
            if (this.skippedAppendCount <= 1) {
                return this.task;
            }
            return new TaskWithSkippedAppends(this.task, this.skippedAppendCount - 1);
        }

        private TaskWithSkippedAppends incrementSkips() {
            return new TaskWithSkippedAppends(this.task, this.skippedAppendCount + 1);
        }

        @VisibleForTesting
        Runnable taskForTesting() {
            return this.task;
        }

        @VisibleForTesting
        int skippedAppendCountForTesting() {
            return this.skippedAppendCount;
        }
    }
}

