/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.util.concurrent.Striped;
import com.google.devtools.build.lib.concurrent.KeyedLocker;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class StripedKeyedLocker<K>
implements KeyedLocker<K> {
    private final Striped<ReadWriteLock> locks;

    public StripedKeyedLocker(int stripes) {
        this.locks = Striped.readWriteLock(stripes);
    }

    private static KeyedLocker.AutoUnlocker lockAndMakeAutoUnlocker(final Lock lock, final Object keyForDebugging) {
        lock.lock();
        return new KeyedLocker.AutoUnlocker(){
            private final AtomicBoolean closeCalled = new AtomicBoolean(false);

            @Override
            public void close() {
                if (this.closeCalled.getAndSet(true)) {
                    String msg = String.format("For key %s, 'close' can be called at most once per AutoUnlocker instance", keyForDebugging);
                    throw new KeyedLocker.AutoUnlocker.IllegalUnlockException(msg);
                }
                lock.unlock();
            }
        };
    }

    @Override
    public KeyedLocker.AutoUnlocker writeLock(K key) {
        return StripedKeyedLocker.lockAndMakeAutoUnlocker(this.locks.get(key).writeLock(), key);
    }

    @Override
    public KeyedLocker.AutoUnlocker readLock(K key) {
        return StripedKeyedLocker.lockAndMakeAutoUnlocker(this.locks.get(key).readLock(), key);
    }
}

