/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Sharder<T>
implements Iterable<List<T>> {
    private final List<List<T>> shards;
    private int nextShard = 0;

    public Sharder(int maxNumShards, int expectedTotalSize) {
        Preconditions.checkArgument(maxNumShards > 0);
        Preconditions.checkArgument(expectedTotalSize >= 0);
        this.shards = Sharder.immutableListOfLists(maxNumShards, expectedTotalSize / maxNumShards);
    }

    public void add(T item) {
        this.shards.get(this.nextShard).add(item);
        this.nextShard = (this.nextShard + 1) % this.shards.size();
    }

    private static <T> List<List<T>> immutableListOfLists(int numLists, int expectedSize) {
        ArrayList list = Lists.newArrayListWithCapacity(numLists);
        for (int i = 0; i < numLists; ++i) {
            list.add(Lists.newArrayListWithExpectedSize(expectedSize));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Iterator<List<T>> iterator() {
        return Iterables.filter(this.shards, list -> !list.isEmpty()).iterator();
    }
}

