/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.collect.Interner;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class PooledInterner<T>
implements Interner<T> {
    private final Interner<T> weakInterner = BlazeInterners.newWeakInterner();
    private final Map<?, ?> internerAsMap = PooledInterner.getMapReflectively(this.weakInterner);

    protected PooledInterner() {
    }

    private static Map<?, ?> getMapReflectively(Interner<?> interner) {
        try {
            Field field = interner.getClass().getDeclaredField("map");
            field.setAccessible(true);
            return (Map)field.get(interner);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @CanIgnoreReturnValue
    public final T weakIntern(T sample) {
        return this.weakInterner.intern(sample);
    }

    public final void removeWeak(Object sample) {
        this.internerAsMap.remove(sample);
    }

    @Override
    public final T intern(T sample) {
        Pool<T> pool = this.getPool();
        return pool != null ? pool.getOrWeakIntern(sample) : this.weakInterner.intern(sample);
    }

    @Nullable
    @ForOverride
    protected abstract Pool<T> getPool();

    public static interface Pool<T> {
        public T getOrWeakIntern(T var1);
    }
}

