/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;

final class PaddedAddresses {
    @VisibleForTesting
    static final long ALIGNMENT = 128L;
    private static final long PADDING_WIDTH = 120L;

    private PaddedAddresses() {
    }

    static long createPaddedBaseAddress(int count) {
        return UnsafeProvider.unsafe().allocateMemory((long)count * 128L + 120L);
    }

    static long getAlignedAddress(long baseAddress, int offset) {
        long cacheLineAddress = baseAddress + 120L & 0xFFFFFFFFFFFFFF80L;
        return cacheLineAddress + (long)offset * 128L;
    }
}

