/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;

public class NamedForkJoinPool
extends ForkJoinPool {
    public static NamedForkJoinPool newNamedPool(String name, int numThreads) {
        return new NamedForkJoinPool(name, numThreads);
    }

    private NamedForkJoinPool(String name, int poolSize) {
        super(poolSize, new NamedForkJoinWorkerThreadFactory(name + "-%s"), null, false);
    }

    private static class NamedForkJoinWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final String nameFormat;
        private final AtomicLong nextUnusedThreadIndex = new AtomicLong(0L);

        NamedForkJoinWorkerThreadFactory(String nameFormat) {
            this.nameFormat = nameFormat;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new NamedForkJoinWorkerThread(forkJoinPool, String.format(this.nameFormat, this.nextUnusedThreadIndex.getAndIncrement()));
        }
    }

    private static class NamedForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        public NamedForkJoinWorkerThread(ForkJoinPool forkJoinPool, String name) {
            super(forkJoinPool);
            this.setName(name);
        }
    }
}

