/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Set;
import java.util.concurrent.Semaphore;

public abstract class MultisetSemaphore<T> {
    public abstract void acquireAll(Set<T> var1) throws InterruptedException;

    public abstract void releaseAll(Set<T> var1);

    public abstract int estimateCurrentNumUniqueValues();

    public static <T> MultisetSemaphore<T> unbounded() {
        return UnboundedMultisetSemaphore.instance();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class NaiveMultisetSemaphore<T>
    extends MultisetSemaphore<T> {
        private final int maxNumUniqueValues;
        private final Semaphore semaphore;
        private final Object lock = new Object();
        private final HashMultiset<T> actualValues = HashMultiset.create();

        private NaiveMultisetSemaphore(int maxNumUniqueValues) {
            this.maxNumUniqueValues = maxNumUniqueValues;
            this.semaphore = new Semaphore(maxNumUniqueValues);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void acquireAll(Set<T> valuesToAcquire) throws InterruptedException {
            int oldNumNeededPermits;
            Object object = this.lock;
            synchronized (object) {
                oldNumNeededPermits = this.computeNumNeededPermitsLocked(valuesToAcquire);
            }
            while (true) {
                this.semaphore.acquire(oldNumNeededPermits);
                object = this.lock;
                synchronized (object) {
                    int newNumNeededPermits = this.computeNumNeededPermitsLocked(valuesToAcquire);
                    if (newNumNeededPermits == oldNumNeededPermits) {
                        valuesToAcquire.forEach(x$0 -> this.actualValues.add(x$0));
                        return;
                    }
                    this.semaphore.release(oldNumNeededPermits);
                    oldNumNeededPermits = newNumNeededPermits;
                }
            }
        }

        private int computeNumNeededPermitsLocked(Set<T> valuesToAcquire) {
            return (int)valuesToAcquire.stream().filter(v -> this.actualValues.count(v) == 0).count();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseAll(Set<T> valuesToRelease) {
            Object object = this.lock;
            synchronized (object) {
                int numPermitsToRelease = valuesToRelease.stream().mapToInt(v -> this.actualValues.remove(v, 1) == 1 ? 1 : 0).sum();
                this.semaphore.release(numPermitsToRelease);
            }
        }

        @Override
        public int estimateCurrentNumUniqueValues() {
            return this.maxNumUniqueValues - this.semaphore.availablePermits();
        }
    }

    private static class UnboundedMultisetSemaphore<T>
    extends MultisetSemaphore<T> {
        private static final UnboundedMultisetSemaphore<Object> INSTANCE = new UnboundedMultisetSemaphore();

        private UnboundedMultisetSemaphore() {
        }

        private static <T> UnboundedMultisetSemaphore<T> instance() {
            return INSTANCE;
        }

        @Override
        public void acquireAll(Set<T> valuesToAcquire) throws InterruptedException {
        }

        @Override
        public void releaseAll(Set<T> valuesToRelease) {
        }

        @Override
        public int estimateCurrentNumUniqueValues() {
            return 0;
        }
    }

    public static class Builder {
        private static final int UNSET_INT = -1;
        private int maxNumUniqueValues = -1;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder maxNumUniqueValues(int maxNumUniqueValues) {
            Preconditions.checkState(maxNumUniqueValues > 0, "maxNumUniqueValues must be positive (was %s)", maxNumUniqueValues);
            this.maxNumUniqueValues = maxNumUniqueValues;
            return this;
        }

        public <T> MultisetSemaphore<T> build() {
            Preconditions.checkState(this.maxNumUniqueValues != -1, "maxNumUniqueValues(int) must be specified");
            return new NaiveMultisetSemaphore(this.maxNumUniqueValues);
        }
    }
}

