/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.devtools.build.lib.concurrent.AbstractQueueVisitor;
import com.google.devtools.build.lib.concurrent.ErrorClassifier;
import com.google.devtools.build.lib.concurrent.MultiThreadPoolsQuiescingExecutor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class MultiExecutorQueueVisitor
extends AbstractQueueVisitor
implements MultiThreadPoolsQuiescingExecutor {
    private final ExecutorService regularPoolExecutorService = super.getExecutorService();
    private final ExecutorService cpuHeavyPoolExecutorService;
    @Nullable
    private final ExecutorService executionPhaseExecutorService;
    private boolean executionPhaseTasksGoAhead;
    @Nullable
    @GuardedBy(value="this")
    private List<Runnable> queuedPendingGoAhead;

    private MultiExecutorQueueVisitor(ExecutorService regularPoolExecutorService, ExecutorService cpuHeavyPoolExecutorService, @Nullable ExecutorService executionPhaseExecutorService, AbstractQueueVisitor.ExceptionHandlingMode exceptionHandlingMode, ErrorClassifier errorClassifier) {
        super(regularPoolExecutorService, AbstractQueueVisitor.ExecutorOwnership.PRIVATE, exceptionHandlingMode, errorClassifier);
        this.cpuHeavyPoolExecutorService = Preconditions.checkNotNull(cpuHeavyPoolExecutorService);
        this.executionPhaseExecutorService = executionPhaseExecutorService;
        boolean bl = this.executionPhaseTasksGoAhead = executionPhaseExecutorService == null;
        if (executionPhaseExecutorService != null) {
            this.queuedPendingGoAhead = Lists.newArrayList();
        }
    }

    public static MultiExecutorQueueVisitor createWithExecutorServices(ExecutorService regularPoolExecutorService, ExecutorService cpuHeavyPoolExecutorService, AbstractQueueVisitor.ExceptionHandlingMode exceptionHandlingMode, ErrorClassifier errorClassifier) {
        return MultiExecutorQueueVisitor.createWithExecutorServices(regularPoolExecutorService, cpuHeavyPoolExecutorService, null, exceptionHandlingMode, errorClassifier);
    }

    public static MultiExecutorQueueVisitor createWithExecutorServices(ExecutorService regularPoolExecutorService, ExecutorService cpuHeavyPoolExecutorService, ExecutorService executionPhaseExecutorService, AbstractQueueVisitor.ExceptionHandlingMode exceptionHandlingMode, ErrorClassifier errorClassifier) {
        return new MultiExecutorQueueVisitor(regularPoolExecutorService, cpuHeavyPoolExecutorService, executionPhaseExecutorService, exceptionHandlingMode, errorClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable, MultiThreadPoolsQuiescingExecutor.ThreadPoolType threadPoolType, boolean shouldStallAwaitingSignal) {
        if (shouldStallAwaitingSignal && !this.executionPhaseTasksGoAhead) {
            MultiExecutorQueueVisitor multiExecutorQueueVisitor = this;
            synchronized (multiExecutorQueueVisitor) {
                if (!this.executionPhaseTasksGoAhead) {
                    Preconditions.checkNotNull(this.queuedPendingGoAhead).add(runnable);
                    return;
                }
            }
        }
        super.executeWithExecutorService(runnable, this.getExecutorServiceByThreadPoolType(threadPoolType));
    }

    @VisibleForTesting
    ExecutorService getExecutorServiceByThreadPoolType(MultiThreadPoolsQuiescingExecutor.ThreadPoolType threadPoolType) {
        switch (threadPoolType) {
            case REGULAR: {
                return this.regularPoolExecutorService;
            }
            case CPU_HEAVY: {
                return this.cpuHeavyPoolExecutorService;
            }
            case EXECUTION_PHASE: {
                Preconditions.checkNotNull(this.executionPhaseExecutorService);
                return this.executionPhaseExecutorService;
            }
        }
        throw new IllegalStateException("Invalid ThreadPoolType: " + threadPoolType);
    }

    @Override
    protected void shutdownExecutorService(Throwable catastrophe) {
        if (catastrophe != null) {
            Throwables.throwIfUnchecked(catastrophe);
        }
        this.internalShutdownExecutorService(this.regularPoolExecutorService);
        this.internalShutdownExecutorService(this.cpuHeavyPoolExecutorService);
        if (this.executionPhaseExecutorService != null) {
            this.internalShutdownExecutorService(this.executionPhaseExecutorService);
        }
    }

    private void internalShutdownExecutorService(ExecutorService executorService) {
        executorService.shutdown();
        while (true) {
            try {
                executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.setInterrupted();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchQueuedUpExecutionPhaseTasks() {
        MultiExecutorQueueVisitor multiExecutorQueueVisitor = this;
        synchronized (multiExecutorQueueVisitor) {
            this.executionPhaseTasksGoAhead = true;
            for (Runnable runnable : Preconditions.checkNotNull(this.queuedPendingGoAhead)) {
                this.execute(runnable, MultiThreadPoolsQuiescingExecutor.ThreadPoolType.EXECUTION_PHASE, false);
            }
            this.queuedPendingGoAhead = null;
        }
    }

    @Override
    public boolean hasSeparatePoolForExecutionTasks() {
        return this.executionPhaseExecutorService != null;
    }
}

