/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class MoreFutures {
    private MoreFutures() {
    }

    public static <V> void waitForAllInterruptiblyFailFast(Iterable<? extends Future<? extends V>> futures) throws ExecutionException, InterruptedException {
        int numCompletedFutures;
        int numFutures = Iterables.size(futures);
        do {
            numCompletedFutures = 0;
            for (Future<V> future : futures) {
                try {
                    future.get(1L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    continue;
                }
                ++numCompletedFutures;
            }
        } while (numCompletedFutures != numFutures);
    }

    public static <V> ListenableFuture<List<V>> allAsListOrCancelAll(final Iterable<? extends ListenableFuture<? extends V>> futures) {
        ListenableFuture combinedFuture = Futures.allAsList(futures);
        Futures.addCallback(combinedFuture, new FutureCallback<List<V>>(){

            @Override
            public void onSuccess(@Nullable List<V> vs) {
            }

            @Override
            public void onFailure(Throwable ignore) {
                for (ListenableFuture future : futures) {
                    future.cancel(true);
                }
            }
        }, MoreExecutors.directExecutor());
        return combinedFuture;
    }

    public static <R> R waitForFutureAndGet(Future<R> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause(), InterruptedException.class);
            throw new IllegalStateException(e);
        }
    }

    public static <R, E extends Exception> R waitForFutureAndGetWithCheckedException(Future<R> future, Class<E> exceptionClass) throws E, InterruptedException {
        return MoreFutures.waitForFutureAndGetWithCheckedException(future, exceptionClass, null);
    }

    public static <R, E1 extends Exception, E2 extends Exception> R waitForFutureAndGetWithCheckedException(Future<R> future, Class<E1> exceptionClass1, @Nullable Class<E2> exceptionClass2) throws E1, E2, InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (exceptionClass2 == null) {
                Throwables.propagateIfPossible(e.getCause(), exceptionClass1);
            } else {
                Throwables.propagateIfPossible(e.getCause(), exceptionClass1, exceptionClass2);
            }
            Throwables.throwIfInstanceOf(e.getCause(), InterruptedException.class);
            throw new IllegalStateException(e);
        }
    }
}

