/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.concurrent.AbstractQueueVisitor;
import com.google.devtools.build.lib.concurrent.ErrorClassifier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public class ForkJoinQuiescingExecutor
extends AbstractQueueVisitor {
    private ForkJoinQuiescingExecutor(ForkJoinPool forkJoinPool, ErrorClassifier errorClassifier) {
        super(forkJoinPool, AbstractQueueVisitor.ExecutorOwnership.PRIVATE, AbstractQueueVisitor.ExceptionHandlingMode.FAIL_FAST, errorClassifier);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected void executeWrappedRunnable(AbstractQueueVisitor.WrappedRunnable runnable, ExecutorService executorService) {
        if (ForkJoinTask.getPool() == executorService) {
            ForkJoinTask<?> forkJoinTask = ForkJoinTask.adapt(runnable).fork();
        } else {
            super.executeWrappedRunnable(runnable, executorService);
        }
    }

    public static class Builder {
        private ForkJoinPool forkJoinPool = null;
        private ErrorClassifier errorClassifier = ErrorClassifier.DEFAULT;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder withOwnershipOf(ForkJoinPool forkJoinPool) {
            Preconditions.checkState(this.forkJoinPool == null);
            this.forkJoinPool = forkJoinPool;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setErrorClassifier(ErrorClassifier errorClassifier) {
            this.errorClassifier = errorClassifier;
            return this;
        }

        public ForkJoinQuiescingExecutor build() {
            Preconditions.checkNotNull(this.forkJoinPool, "fork join pool must be supplied");
            return new ForkJoinQuiescingExecutor(this.forkJoinPool, this.errorClassifier);
        }
    }
}

