/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class FastHotKeyAtomicLongMap<T> {
    private final ConcurrentMap<T, AtomicLong> map = new ConcurrentHashMap<T, AtomicLong>();

    public static <T> FastHotKeyAtomicLongMap<T> create() {
        return new FastHotKeyAtomicLongMap<T>();
    }

    public static <T> FastHotKeyAtomicLongMap<T> create(int concurrencyLevel) {
        return new FastHotKeyAtomicLongMap<T>();
    }

    private FastHotKeyAtomicLongMap() {
    }

    public long incrementAndGet(T key) {
        return this.getCounter(key).incrementAndGet();
    }

    public long decrementAndGet(T key) {
        return this.getCounter(key).decrementAndGet();
    }

    public ImmutableMap<T, Long> asImmutableMap() {
        return ImmutableMap.copyOf(Maps.transformValues(this.map, AtomicLong::get));
    }

    public AtomicLong getCounter(T element) {
        AtomicLong counter = (AtomicLong)this.map.get(element);
        return counter != null ? counter : this.map.computeIfAbsent(element, s2 -> new AtomicLong(0L));
    }

    public void clear() {
        this.map.clear();
    }
}

